/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$$anonfun$handleChildChange$1$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003-\u0001AQaA\rA\u0002UAqa\b\u0001C\u0002\u0013%\u0001%A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012!\t\t\u0003-\tJ!a\t\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"1Q\u0006\u0001Q\u0001\n%\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\tu.\u001cE.[3oiV\t\u0011\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005A!p[2mS\u0016tGO\u0003\u00027o\u00051\u0011\nM%uK\u000eT\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e4\u0005!Q6n\u00117jK:$\bB\u0002\u001f\u0001A\u0003%\u0011'A\u0005{W\u000ec\u0017.\u001a8uA!9a\b\u0001a\u0001\n\u0003y\u0014\u0001\u0004:fa2L7-Y*uCR,W#\u0001!\u0011\t\u00053\u0005jS\u0007\u0002\u0005*\u00111\tR\u0001\b[V$\u0018M\u00197f\u0015\t)%\"\u0001\u0006d_2dWm\u0019;j_:L!a\u0012\"\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0017\u0013&\u0011!J\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\t\u0003-1K!!\u0014\u0002\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\t\u000f=\u0003\u0001\u0019!C\u0001!\u0006\u0001\"/\u001a9mS\u000e\f7\u000b^1uK~#S-\u001d\u000b\u0003#R\u0003\"!\u0003*\n\u0005MS!\u0001B+oSRDq!\u0016(\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBaa\u0016\u0001!B\u0013\u0001\u0015!\u0004:fa2L7-Y*uCR,\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u00027B\u0011a\u0003X\u0005\u0003;\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004`\u0001\u0001\u0006IaW\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u0003)A\u0017m]*uCJ$X\rZ\u000b\u0002GB\u0011A-\\\u0007\u0002K*\u0011amZ\u0001\u0007CR|W.[2\u000b\u0005!L\u0017AC2p]\u000e,(O]3oi*\u0011!n[\u0001\u0005kRLGNC\u0001m\u0003\u0011Q\u0017M^1\n\u00059,'!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004q\u0001\u0001\u0006IaY\u0001\fQ\u0006\u001c8\u000b^1si\u0016$\u0007\u0005C\u0004s\u0001\t\u0007I\u0011B:\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0003m_\u001e$$N\u0003\u0002zo\u00051\u0011\r]1dQ\u0016L!a\u001f<\u0003\r1{wmZ3s\u0011\u0019i\b\u0001)A\u0005i\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u000591\u000f^1siV\u0004H#A)\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\u0002\u0005\t\"/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\u0002\u0005A1\u000f[;uI><h\u000eC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\b#\u0006E\u0011QDA\u0011\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011\u0001\u0003:fa2L7-Y:\u0011\u000b\u0005]\u0011\u0011\u0004%\u000e\u0003\u0011K1!a\u0007E\u0005\r\u0019V\r\u001e\u0005\b\u0003?\tY\u00011\u0001L\u0003-!\u0018M]4fiN#\u0018\r^3\t\u0015\u0005\r\u00121\u0002I\u0001\u0002\u0004\t)#A\u0005dC2d'-Y2lgB\u0019a#a\n\n\u0007\u0005%\"AA\u0005DC2d'-Y2lg\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKR9\u0011+!\r\u00026\u0005]\u0002bBA\u001a\u0003W\u0001\r\u0001S\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003?\tY\u00031\u0001L\u0011!\t\u0019#a\u000bA\u0002\u0005\u0015\u0002bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u001eCJ,\u0017\t\u001c7SKBd\u0017nY1t\r>\u0014Hk\u001c9jG\u0012+G.\u001a;fIR!\u0011qHA#!\rI\u0011\u0011I\u0005\u0004\u0003\u0007R!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u000f\nI\u00041\u0001\u0002J\u0005)Ao\u001c9jGB!\u00111JA)\u001d\rI\u0011QJ\u0005\u0004\u0003\u001fR\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#AB*ue&twMC\u0002\u0002P)Aq!!\u0017\u0001\t\u0003\tY&A\u0015jg\u0006#H*Z1ti>sWMU3qY&\u001c\u0017-\u00138EK2,G/[8o'R\f'\u000f^3e'R\fG/\u001a\u000b\u0005\u0003\u007f\ti\u0006\u0003\u0005\u0002H\u0005]\u0003\u0019AA%\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\nqB]3qY&\u001c\u0017m]%o'R\fG/\u001a\u000b\u0007\u0003+\t)'a\u001a\t\u0011\u0005\u001d\u0013q\fa\u0001\u0003\u0013Bq!!\u001b\u0002`\u0001\u00071*A\u0003ti\u0006$X\rC\u0004\u0002n\u0001!\t!a\u001c\u00021I,\u0007\u000f\\5dCNLe\u000eR3mKRLwN\\*uCR,7\u000f\u0006\u0003\u0002\u0016\u0005E\u0004\u0002CA$\u0003W\u0002\r!!\u0013\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\u0005I\u0012m]:feR4\u0016\r\\5e!J,g/[8vgN#\u0018\r^3t)\u001d\t\u0016\u0011PA>\u0003\u000bCq!a\r\u0002t\u0001\u0007\u0001\n\u0003\u0005\u0002~\u0005M\u0004\u0019AA@\u0003)1'o\\7Ti\u0006$Xm\u001d\t\u0006\u0003/\t\tiS\u0005\u0004\u0003\u0007#%aA*fc\"9\u0011qDA:\u0001\u0004Y\u0005bBAE\u0001\u0011%\u00111R\u0001\u001de\u0016<\u0017n\u001d;fe\n\u0013xn[3s\u0007\"\fgnZ3MSN$XM\\3s)\t\ti\t\u0005\u0004\u0002\u0010\u0006E\u0015QS\u0007\u0002S&\u0019\u00111S5\u0003\t1K7\u000f\u001e\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111T6\u0002\t1\fgnZ\u0005\u0005\u0003'\nI\nC\u0004\u0002\"\u0002!I!!\u0001\u0002-%t\u0017\u000e^5bY&TXMU3qY&\u001c\u0017m\u0015;bi\u0016Dq!!*\u0001\t\u0003\t9+\u0001\u000eqCJ$\u0018\u000e^5p]N\f5o]5h]\u0016$Gk\u001c\"s_.,'\u000f\u0006\u0004\u0002*\u0006]\u0016Q\u0018\t\u0007\u0003/\t\t)a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-\u0005\u0003\u0019\u0019w.\\7p]&!\u0011QWAX\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003s\u000b\u0019\u000b1\u0001\u0002<\u00061Ao\u001c9jGN\u0004b!a\u0006\u0002\u0002\u0006%\u0003bBA`\u0003G\u0003\r!K\u0001\tEJ|7.\u001a:JI\u001a1\u00111\u0019\u0001\u0001\u0003\u000b\u0014AC\u0011:pW\u0016\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148cBAa\u0003\u000f\fiM\u0004\t\u0005\u0003/\u000bI-\u0003\u0003\u0002L\u0006e%AB(cU\u0016\u001cG\u000fE\u00023\u0003\u001fL1!!54\u0005AI%l[\"iS2$G*[:uK:,'\u000fC\u0004\u001b\u0003\u0003$\t!!6\u0015\u0005\u0005]\u0007\u0003BAm\u0003\u0003l\u0011\u0001\u0001\u0005\t\u0003;\f\t\r\"\u0001\u0002`\u0006\t\u0002.\u00198eY\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3\u0015\u000bE\u000b\t/!:\t\u0011\u0005\r\u00181\u001ca\u0001\u0003\u0013\n!\u0002]1sK:$\b+\u0019;i\u0011!\t9/a7A\u0002\u0005%\u0018!E2veJ,g\u000e\u001e\"s_.,'\u000fT5tiB1\u0011qRAI\u0003\u0013B\u0011\"!<\u0001#\u0003%\t!a<\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001f\u0016\u0005\u0003K\t\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\r\tyPC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> x$1) {
        this.replicaState = x$1;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.replicaState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.size() > 0) {
            this.info((Function0<String>)new Serializable(this, replicas, targetState){
                public static final long serialVersionUID = 0L;
                private final Set replicas$1;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
                }
                {
                    this.replicas$1 = replicas$1;
                    this.targetState$1 = targetState$1;
                }
            });
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1)new Serializable(this, targetState, callbacks){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final ReplicaState targetState$1;
                    private final Callbacks callbacks$1;

                    public final void apply(PartitionAndReplica r) {
                        this.$outer.handleStateChange(r, this.targetState$1, this.callbacks$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.targetState$1 = targetState$1;
                        this.callbacks$1 = callbacks$1;
                    }
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, targetState){
                    public static final long serialVersionUID = 0L;
                    private final ReplicaState targetState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                    }
                    {
                        this.targetState$1 = targetState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block14: {
            TopicAndPartition topicAndPartition;
            int replicaId;
            block15: {
                String topic = partitionAndReplica.topic();
                int partition = partitionAndReplica.partition();
                replicaId = partitionAndReplica.replica();
                topicAndPartition = new TopicAndPartition(topic, partition);
                if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) break block15;
                ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonExistentReplica$ apply() {
                        return NonExistentReplica$.MODULE$;
                    }
                });
                try {
                    ReplicaState replicaState;
                    block26: {
                        Option option;
                        block32: {
                            boolean bl;
                            block31: {
                                block27: {
                                    Option<LeaderIsrAndControllerEpoch> option2;
                                    block30: {
                                        boolean bl2;
                                        block29: {
                                            block28: {
                                                Seq replicaAssignment;
                                                block20: {
                                                    Option option3;
                                                    block25: {
                                                        block22: {
                                                            block24: {
                                                                block23: {
                                                                    block21: {
                                                                        block16: {
                                                                            Option<LeaderIsrAndControllerEpoch> option4;
                                                                            block19: {
                                                                                block18: {
                                                                                    block17: {
                                                                                        Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt;
                                                                                        replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                                        replicaState = targetState;
                                                                                        NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                                        ReplicaState replicaState2 = replicaState;
                                                                                        if (newReplica$ != null ? !newReplica$.equals(replicaState2) : replicaState2 != null) break block16;
                                                                                        this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), targetState);
                                                                                        option4 = leaderIsrAndControllerEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), topic, partition);
                                                                                        if (!(option4 instanceof Some)) break block17;
                                                                                        Some some = (Some)option4;
                                                                                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                                        if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                                                                                            throw new StateChangeFailedException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                                                                                        }
                                                                                        this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        break block18;
                                                                                    }
                                                                                    None$ none$ = None$.MODULE$;
                                                                                    Option<LeaderIsrAndControllerEpoch> option5 = option4;
                                                                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block19;
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                }
                                                                                this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                break block14;
                                                                            }
                                                                            throw new MatchError(option4);
                                                                        }
                                                                        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                                                                        ReplicaState replicaState3 = replicaState;
                                                                        if (!(replicaDeletionStarted$ != null ? !replicaDeletionStarted$.equals(replicaState3) : replicaState3 != null)) {
                                                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), targetState);
                                                                            this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                                                                            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block14;
                                                                        }
                                                                        ReplicaDeletionIneligible$ replicaDeletionIneligible$ = ReplicaDeletionIneligible$.MODULE$;
                                                                        ReplicaState replicaState4 = replicaState;
                                                                        if (!(replicaDeletionIneligible$ != null ? !replicaDeletionIneligible$.equals(replicaState4) : replicaState4 != null)) {
                                                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                            this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block14;
                                                                        }
                                                                        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                                                                        ReplicaState replicaState5 = replicaState;
                                                                        if (!(replicaDeletionSuccessful$ != null ? !replicaDeletionSuccessful$.equals(replicaState5) : replicaState5 != null)) {
                                                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                            this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block14;
                                                                        }
                                                                        NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                                                                        ReplicaState replicaState6 = replicaState;
                                                                        if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState6) : replicaState6 != null)) {
                                                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionSuccessful$[]{ReplicaDeletionSuccessful$.MODULE$})), targetState);
                                                                            Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                            this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final int replicaId$1;

                                                                                public final boolean apply(int x$1) {
                                                                                    return this.apply$mcZI$sp(x$1);
                                                                                }

                                                                                public boolean apply$mcZI$sp(int x$1) {
                                                                                    return x$1 == this.replicaId$1;
                                                                                }
                                                                                {
                                                                                    this.replicaId$1 = replicaId$1;
                                                                                }
                                                                            }));
                                                                            this.replicaState().remove((Object)partitionAndReplica);
                                                                            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block14;
                                                                        }
                                                                        OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                                                                        ReplicaState replicaState7 = replicaState;
                                                                        if (onlineReplica$ != null ? !onlineReplica$.equals(replicaState7) : replicaState7 != null) break block20;
                                                                        this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                                                        ReplicaState replicaState8 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                                                                        NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                        ReplicaState replicaState9 = replicaState8;
                                                                        if (newReplica$ != null ? !newReplica$.equals(replicaState9) : replicaState9 != null) break block21;
                                                                        Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                        Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom()));
                                                                        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block22;
                                                                    }
                                                                    option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                                    if (!(option3 instanceof Some)) break block23;
                                                                    Some some = (Some)option3;
                                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                                    this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block24;
                                                                }
                                                                None$ none$ = None$.MODULE$;
                                                                Option option6 = option3;
                                                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block25;
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block14;
                                                    }
                                                    throw new MatchError((Object)option3);
                                                }
                                                OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                                                ReplicaState replicaState10 = replicaState;
                                                if (offlineReplica$ != null ? !offlineReplica$.equals(replicaState10) : replicaState10 != null) break block26;
                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                                this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                                option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                if (!(option instanceof Some)) break block27;
                                                option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic, partition, replicaId);
                                                if (!(option2 instanceof Some)) break block28;
                                                Some some = (Some)option2;
                                                LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{updatedLeaderIsrAndControllerEpoch.leaderAndIsr().leader()})), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                                                bl2 = false;
                                                break block29;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option<LeaderIsrAndControllerEpoch> option7 = option2;
                                            if (none$ != null ? !none$.equals(option7) : option7 != null) break block30;
                                            bl2 = true;
                                        }
                                        bl = bl2;
                                        break block31;
                                    }
                                    throw new MatchError(option2);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option8 = option;
                                if (none$ != null ? !none$.equals(option8) : option8 != null) break block32;
                                bl = true;
                            }
                            boolean leaderAndIsrIsEmpty = bl;
                            if (leaderAndIsrIsEmpty) {
                                throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block14;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)replicaState);
                }
                catch (Throwable throwable) {
                    this.stateChangeLogger().error((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topic, BoxesRunTime.boxToInteger((int)partition), currState, targetState})), throwable);
                }
            }
            throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, targetState})));
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.debug((Function0<String>)new Serializable(this, topic, replicaStatesForTopic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final scala.collection.immutable.Map replicaStatesForTopic$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Are all replicas for topic %s deleted %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.replicaStatesForTopic$1}));
            }
            {
                this.topic$1 = topic$1;
                this.replicaStatesForTopic$1 = replicaStatesForTopic$1;
            }
        });
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!deletionState) return false;
                Object object = r._2();
                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionSuccessful$)) return false;
                    return true;
                }
                if (replicaDeletionSuccessful$ == null) return true;
                return false;
            }
        }));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (deletionState) return true;
                Object object = r._2();
                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionStarted$)) return false;
                    return true;
                }
                if (replicaDeletionStarted$ == null) return true;
                return false;
            }
        }));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState().filter((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final ReplicaState state$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$2)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$1;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$2 = topic$2;
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1)new Serializable(this, topic, deletionStates){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final Set deletionStates$1;

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                return ((PartitionAndReplica)r._1()).topic().equals(this.topic$3) && JavaConversions$.MODULE$.setAsJavaSet(this.deletionStates$1).contains(r._2());
            }
            {
                this.topic$3 = topic$3;
                this.deletionStates$1 = deletionStates$1;
            }
        })).keySet();
    }

    private void assertValidPreviousStates(PartitionAndReplica partitionAndReplica, Seq<ReplicaState> fromStates, ReplicaState targetState) {
        Predef$.MODULE$.assert(fromStates.contains(this.replicaState().apply((Object)partitionAndReplica)), (Function0)new Serializable(this, partitionAndReplica, fromStates, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final PartitionAndReplica partitionAndReplica$1;
            private final Seq fromStates$1;
            private final ReplicaState targetState$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndReplica$1, this.fromStates$1.mkString(","), this.targetState$2}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.replicaState().apply((Object)this.partitionAndReplica$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionAndReplica$1 = partitionAndReplica$1;
                this.fromStates$1 = fromStates$1;
                this.targetState$2 = targetState$2;
            }
        });
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener());
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> x$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x$2;
                if (tuple2 != null) {
                    TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                    Seq assignedReplicas = (Seq)tuple2._2();
                    String topic = topicPartition.topic();
                    int partition = topicPartition.partition();
                    assignedReplicas.foreach((Function1)new Serializable(this, topic, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeReplicaState$2 $outer;
                        private final String topic$4;
                        private final int partition$1;

                        public final Option<ReplicaState> apply(int replicaId) {
                            boolean bl;
                            block4: {
                                Option option;
                                block3: {
                                    PartitionAndReplica partitionAndReplica;
                                    block2: {
                                        partitionAndReplica = new PartitionAndReplica(this.topic$4, this.partition$1, replicaId);
                                        bl = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replicaId));
                                        if (!bl) break block2;
                                        option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                }
                                return option;
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$4 = topic$4;
                            this.partition$1 = partition$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                return ((SeqLike)x$3._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleChildChange(String parentPath, List<String> currentBrokerList) {
            this.info((Function0<String>)new Serializable(this, parentPath, currentBrokerList){
                public static final long serialVersionUID = 0L;
                private final String parentPath$1;
                private final List currentBrokerList$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Broker change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).mkString(",")}));
                }
                {
                    this.parentPath$1 = parentPath$1;
                    this.currentBrokerList$1 = currentBrokerList$1;
                }
            });
            Utils$.MODULE$.inLock(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock(), new Serializable(this, currentBrokerList){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BrokerChangeListener $outer;
                public final List currentBrokerList$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$hasStarted().get()) {
                        ControllerStats$.MODULE$.leaderElectionTimer().time(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                try {
                                    scala.collection.immutable.Set curBrokerIds = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.$outer.currentBrokerList$1).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$4) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
                                        }
                                    }, Buffer$.MODULE$.canBuildFrom())).toSet();
                                    scala.collection.immutable.Set newBrokerIds = (scala.collection.immutable.Set)curBrokerIds.$minus$minus(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds());
                                    scala.collection.immutable.Set newBrokerInfo = (scala.collection.immutable.Set)newBrokerIds.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        public final Option<Broker> apply(int x$5) {
                                            return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), x$5);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                                    scala.collection.immutable.Set newBrokers = (scala.collection.immutable.Set)((SetLike)newBrokerInfo.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(Option<Broker> x$6) {
                                            return x$6.isDefined();
                                        }
                                    })).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Broker apply(Option<Broker> x$7) {
                                            return (Broker)x$7.get();
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                                    Set deadBrokerIds = (Set)this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds().$minus$minus((GenTraversableOnce)curBrokerIds);
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers_$eq((Set<Broker>)((Set)((SetLike)((TraversableLike)curBrokerIds.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        public final Option<Broker> apply(int x$8) {
                                            return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), x$8);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(Option<Broker> x$9) {
                                            return x$9.isDefined();
                                        }
                                    })).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Broker apply(Option<Broker> x$10) {
                                            return (Broker)x$10.get();
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())));
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().info((Function0<String>)new Serializable(this, newBrokerIds, deadBrokerIds){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;
                                        private final scala.collection.immutable.Set newBrokerIds$1;
                                        private final Set deadBrokerIds$1;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Newly added brokers: %s, deleted brokers: %s, all live brokers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newBrokerIds$1.mkString(","), this.deadBrokerIds$1.mkString(","), this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().mkString(",")}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.newBrokerIds$1 = newBrokerIds$1;
                                            this.deadBrokerIds$1 = deadBrokerIds$1;
                                        }
                                    });
                                    newBrokers.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        public final void apply(Broker x$11) {
                                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().addBroker(x$11);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    deadBrokerIds.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        public final void apply(int x$12) {
                                            this.apply$mcVI$sp(x$12);
                                        }

                                        public void apply$mcVI$sp(int x$12) {
                                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().removeBroker(x$12);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    if (newBrokerIds.size() > 0) {
                                        this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerStartup((Seq<Object>)newBrokerIds.toSeq());
                                    }
                                    if (deadBrokerIds.size() > 0) {
                                        this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerFailure((Seq<Object>)deadBrokerIds.toSeq());
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().error((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Error while handling broker changes";
                                        }
                                    }, (Function0<Throwable>)new Serializable(this, throwable){
                                        public static final long serialVersionUID = 0L;
                                        private final Throwable e$2;

                                        public final Throwable apply() {
                                            return this.e$2;
                                        }
                                        {
                                            this.e$2 = e$2;
                                        }
                                    });
                                }
                            }

                            public /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }

                public /* synthetic */ BrokerChangeListener kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.currentBrokerList$1 = currentBrokerList$1;
                }
            });
        }

        public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return ReplicaStateMachine.this;
        }

        public BrokerChangeListener() {
            if (ReplicaStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)ReplicaStateMachine.this.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

