/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.logging;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public abstract class Logging {
    public static final String PREFIX_KEY = "prefix";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withPrefix(String prefix, Callable<T> callable) throws Exception {
        Map<String, String> mdc = Logging.getCopyOfContextMap();
        try {
            Logging.putPrefix(prefix);
            T t = callable.call();
            return t;
        }
        finally {
            Logging.setContextMap(mdc);
        }
    }

    public static void putThreadContext(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public static Map<String, String> getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> mdc) {
        if (mdc == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(mdc);
        }
    }

    public static void withPrefix(String prefix, Runnable runnable) {
        Map<String, String> mdc = Logging.getCopyOfContextMap();
        try {
            Logging.putPrefix(prefix);
            runnable.run();
        }
        finally {
            Logging.setContextMap(mdc);
        }
    }

    public static Runnable preserve(final Runnable runnable) {
        final Map<String, String> parentMdc = Logging.getCopyOfContextMap();
        return new Runnable(){

            @Override
            public void run() {
                Map<String, String> localMdc = Logging.getCopyOfContextMap();
                try {
                    Logging.setContextMap(parentMdc);
                    runnable.run();
                }
                finally {
                    Logging.setContextMap(localMdc);
                }
            }
        };
    }

    public static void putPrefix(String name) {
        MDC.put((String)PREFIX_KEY, (String)name);
    }
}

