/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.icmp.proxy.IPRangeDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResultDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepSummary;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class PingSweepRequestBuilderImpl
implements PingSweepRequestBuilder {
    protected final RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> client;
    protected long timeout = 800L;
    protected int packetSize = 64;
    protected int retries = 2;
    protected String location;
    protected InetAddress begin;
    protected InetAddress end;
    protected String foreignSource;
    protected List<IPRangeDTO> ranges = new ArrayList<IPRangeDTO>();
    public static final BigDecimal FUDGE_FACTOR = BigDecimal.valueOf(1.5);

    public PingSweepRequestBuilderImpl(RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public PingSweepRequestBuilder withTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit);
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    @Override
    public PingSweepRequestBuilder withPacketSize(int packetSize) {
        this.packetSize = packetSize > 0 ? packetSize : this.packetSize;
        return this;
    }

    @Override
    public PingSweepRequestBuilder withRetries(int retries) {
        this.retries = retries > 0 ? retries : this.retries;
        return this;
    }

    @Override
    public PingSweepRequestBuilder withLocation(String location) {
        this.location = Objects.requireNonNull(location);
        return this;
    }

    @Override
    public CompletableFuture<PingSweepSummary> execute() {
        PingSweepRequestDTO requestDTO = new PingSweepRequestDTO();
        requestDTO.setIpRanges(this.ranges);
        requestDTO.setLocation(this.location);
        requestDTO.setRetries(this.retries);
        requestDTO.setPacketSize(this.packetSize);
        requestDTO.setTimeout(this.timeout);
        requestDTO.setForeignSource(this.foreignSource);
        requestDTO.setTimeToLiveMs(Long.valueOf(this.calculateTaskTimeout()));
        return this.client.execute((RpcRequest)requestDTO).thenApply(responseDTO -> {
            PingSweepSummary summary = new PingSweepSummary();
            ConcurrentMap responses = Maps.newConcurrentMap();
            for (PingSweepResultDTO result : responseDTO.getPingSweepResult()) {
                responses.put(result.getAddress(), result.getRtt());
            }
            summary.setResponses(responses);
            return summary;
        });
    }

    @Override
    public PingSweepRequestBuilder withRange(InetAddress begin, InetAddress end) {
        this.ranges.add(new IPRangeDTO(begin, end));
        return this;
    }

    @Override
    public PingSweepRequestBuilder withIpPollRanges(List<IPPollRange> ranges) {
        ranges.forEach(range -> {
            try {
                InetAddress begin = InetAddress.getByAddress(range.getAddressRange().getBegin());
                InetAddress end = InetAddress.getByAddress(range.getAddressRange().getEnd());
                this.ranges.add(new IPRangeDTO(begin, end));
            }
            catch (Exception e) {
                throw new RuntimeException("Unknown ranges");
            }
        });
        return this;
    }

    public RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> getClient() {
        return this.client;
    }

    @Override
    public PingSweepRequestBuilder withForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
        return this;
    }

    public int calculateTaskTimeout() {
        BigDecimal taskTimeOut = BigDecimal.ZERO;
        for (IPRangeDTO range : this.ranges) {
            BigInteger size = InetAddressUtils.difference((InetAddress)InetAddressUtils.getInetAddress((byte[])range.getEnd().getAddress()), (InetAddress)InetAddressUtils.getInetAddress((byte[])range.getBegin().getAddress())).add(BigInteger.ONE);
            taskTimeOut = taskTimeOut.add(BigDecimal.valueOf(this.retries).add(BigDecimal.ONE, MathContext.DECIMAL64).multiply(new BigDecimal(size), MathContext.DECIMAL64).multiply(BigDecimal.valueOf(this.timeout), MathContext.DECIMAL64).multiply(FUDGE_FACTOR, MathContext.DECIMAL64), MathContext.DECIMAL64);
            taskTimeOut = taskTimeOut.add(new BigDecimal(size).divide(BigDecimal.valueOf(this.packetSize), MathContext.DECIMAL64).multiply(BigDecimal.valueOf(1000L), MathContext.DECIMAL64), MathContext.DECIMAL64);
        }
        return taskTimeOut.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0 ? Integer.MAX_VALUE : taskTimeOut.intValue();
    }
}

