/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrapInformation
implements TrapNotification {
    private static final transient Logger LOG = LoggerFactory.getLogger(TrapInformation.class);
    private final InetAddress m_agent;
    private final String m_community;
    private long m_creationTime = new Date().getTime();
    private String systemId;
    private String location;
    private TrapProcessor m_trapProcessor;

    protected TrapInformation(InetAddress agent, String community, TrapProcessor trapProcessor) {
        this.m_agent = agent;
        this.m_community = community;
        this.m_trapProcessor = trapProcessor;
    }

    public abstract InetAddress getTrapAddress();

    public final String getSystemId() {
        return this.systemId;
    }

    public final void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public final String getLocation() {
        return this.location;
    }

    public final void setLocation(String location) {
        this.location = location;
    }

    public final String getCommunity() {
        return this.m_community;
    }

    protected void validate() {
    }

    public final InetAddress getAgentAddress() {
        return this.m_agent;
    }

    public final long getCreationTime() {
        return this.m_creationTime;
    }

    public final void setCreationTime(long creationTime) {
        this.m_creationTime = creationTime;
    }

    @Override
    public final TrapProcessor getTrapProcessor() {
        return TrapInformation.processTrap(this, this.m_trapProcessor);
    }

    @Override
    public final void setTrapProcessor(TrapProcessor trapProcessor) {
        this.m_trapProcessor = trapProcessor;
    }

    public abstract String getVersion();

    public abstract int getPduLength();

    public abstract long getTimeStamp();

    protected abstract TrapIdentity getTrapIdentity();

    protected static TrapProcessor processTrap(TrapInformation trap, TrapProcessor trapProcessor) {
        trap.validate();
        trapProcessor.setSystemId(trap.getSystemId());
        trapProcessor.setLocation(trap.getLocation());
        trapProcessor.setCreationTime(trap.getCreationTime());
        trapProcessor.setVersion(trap.getVersion());
        trapProcessor.setCommunity(trap.getCommunity());
        trapProcessor.setAgentAddress(trap.getAgentAddress());
        trapProcessor.setTrapAddress(trap.getTrapAddress());
        LOG.debug("{} trap - trapInterface: ()", (Object)trap.getVersion(), (Object)trap.getTrapAddress());
        trapProcessor.setTimeStamp(trap.getTimeStamp());
        trapProcessor.setTrapIdentity(trap.getTrapIdentity());
        for (int i = 0; i < trap.getPduLength(); ++i) {
            trap.processVarBindAt(i);
        }
        return trapProcessor;
    }

    protected abstract void processVarBindAt(int var1);

    protected void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_trapProcessor.processVarBind(name, value);
    }
}

