/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.xml;

import java.util.Objects;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.xml.XmlHandler;

public abstract class AbstractXmlSinkModule<T extends Message>
implements SinkModule<T> {
    private final Class<T> messageClazz;
    private final ThreadLocal<XmlHandler<T>> messageXmlHandler = new ThreadLocal();

    public AbstractXmlSinkModule(Class<T> messageClazz) {
        this.messageClazz = Objects.requireNonNull(messageClazz);
    }

    public String marshal(T message) {
        return this.getXmlHandler().marshal(message);
    }

    public T unmarshal(String message) {
        return (T)((Message)this.getXmlHandler().unmarshal(message));
    }

    private XmlHandler<T> getXmlHandler() {
        XmlHandler<T> xmlHandler = this.messageXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.messageClazz);
            this.messageXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private <W> XmlHandler<W> createXmlHandler(Class<W> clazz) {
        try {
            return new XmlHandler(clazz);
        }
        catch (Throwable t) {
            return new XmlHandler(clazz);
        }
    }
}

