/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SyslogConnection
implements Callable<Callable<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogConnection.class);
    private String m_systemId;
    private String m_location;
    private InetAddress m_sourceAddress;
    private int m_port;
    private ByteBuffer m_bytes;
    private SyslogdConfig m_config;

    public SyslogConnection() {
    }

    public SyslogConnection(DatagramPacket packet, SyslogdConfig config, String systemId, String location) {
        this(packet.getAddress(), packet.getPort(), ByteBuffer.wrap(packet.getData(), 0, packet.getLength()), config, systemId, location);
    }

    public SyslogConnection(InetAddress sourceAddress, int port, ByteBuffer bytes, SyslogdConfig config, String systemId, String location) {
        if (systemId == null) {
            throw new IllegalArgumentException("System ID cannot be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (sourceAddress == null) {
            throw new IllegalArgumentException("Source address cannot be null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes cannot be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_systemId = systemId;
        this.m_location = location;
        this.m_sourceAddress = sourceAddress;
        this.m_port = port;
        this.m_bytes = bytes;
        this.m_config = config;
    }

    @XmlAttribute
    public String getSystemId() {
        return this.m_systemId;
    }

    public void setSystemId(String systemId) {
        this.m_systemId = systemId;
    }

    @XmlAttribute
    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getSourceAddress() {
        return this.m_sourceAddress;
    }

    public void setSourceAddress(InetAddress sourceAddress) {
        this.m_sourceAddress = sourceAddress;
    }

    @XmlAttribute
    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_bytes;
    }

    public void setByteBuffer(ByteBuffer bytes) {
        this.m_bytes = bytes;
    }

    @XmlAttribute
    public byte[] getBytes() {
        this.m_bytes.rewind();
        byte[] retval = new byte[this.m_bytes.remaining()];
        this.m_bytes.get(retval);
        this.m_bytes.rewind();
        return retval;
    }

    public void setBytes(byte[] bytes) {
        this.m_bytes = ByteBuffer.wrap(bytes);
    }

    public SyslogdConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(SyslogdConfig config) {
        this.m_config = config;
    }

    @Override
    public SyslogProcessor call() {
        try {
            LOG.debug("Converting syslog message into event ({} bytes)", (Object)this.m_bytes.remaining());
            ConvertToEvent re = new ConvertToEvent(this.m_systemId, this.m_location, this.m_sourceAddress, this.m_port, StandardCharsets.US_ASCII.decode(this.m_bytes).toString(), this.m_config);
            LOG.debug("Sending syslog event to the SyslogProcessor queue");
            return new SyslogProcessor(re.getEvent(), this.m_config.getNewSuspectOnMessage());
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("Failure to convert package", (Throwable)e);
        }
        catch (MessageDiscardedException e) {
            LOG.info("Message discarded, returning without enqueueing event.", (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception while processing SyslogConnection", e);
        }
        return null;
    }

    private static DatagramPacket copyPacket(DatagramPacket packet) {
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, message, 0, packet.getLength());
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(packet.getAddress().getHostName(), packet.getAddress().getAddress());
            DatagramPacket retPacket = new DatagramPacket(message, packet.getOffset(), packet.getLength(), addr, packet.getPort());
            return retPacket;
        }
        catch (UnknownHostException e) {
            LOG.warn("unable to clone InetAddress object for {}", (Object)packet.getAddress());
            return null;
        }
    }

    public static DatagramPacket copyPacket(InetAddress sourceAddress, int sourcePort, ByteBuffer buffer) {
        byte[] message = new byte[4096];
        int i = 0;
        while (buffer.hasRemaining()) {
            message[i++] = buffer.get();
        }
        return SyslogConnection.copyPacket(sourceAddress, sourcePort, message, i);
    }

    private static DatagramPacket copyPacket(InetAddress sourceAddress, int sourcePort, byte[] buffer, int length) {
        DatagramPacket retPacket = new DatagramPacket(buffer, 0, length, sourceAddress, sourcePort);
        return retPacket;
    }
}

