/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProxy;
import org.springframework.ldap.support.LdapUtils;

public class SingleContextSource
implements ContextSource,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)SingleContextSource.class);
    private final DirContext ctx;

    public SingleContextSource(DirContext ctx) {
        this.ctx = ctx;
    }

    public DirContext getReadOnlyContext() throws NamingException {
        return this.getNonClosingDirContextProxy(this.ctx);
    }

    public DirContext getReadWriteContext() throws NamingException {
        return this.getNonClosingDirContextProxy(this.ctx);
    }

    private DirContext getNonClosingDirContextProxy(DirContext context) {
        return (DirContext)Proxy.newProxyInstance(DirContextProxy.class.getClassLoader(), new Class[]{LdapUtils.getActualTargetClass(context), DirContextProxy.class}, (InvocationHandler)new NonClosingDirContextInvocationHandler(context));
    }

    public DirContext getContext(String principal, String credentials) throws NamingException {
        throw new UnsupportedOperationException("Not a valid operation for this type of ContextSource");
    }

    public void destroy() {
        try {
            this.ctx.close();
        }
        catch (javax.naming.NamingException e) {
            log.warn((Object)e);
        }
    }

    public static class NonClosingDirContextInvocationHandler
    implements InvocationHandler {
        private DirContext target;

        public NonClosingDirContextInvocationHandler(DirContext target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getTargetContext")) {
                return this.target;
            }
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("hashCode")) {
                return new Integer(proxy.hashCode());
            }
            if (methodName.equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

