/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy.strategy;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSequence;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.icmp.proxy.strategy.ExecutionStrategy;
import org.opennms.netmgt.icmp.proxy.strategy.SinglePingExecutionStrategy;

public class MultiplePingExecutionStrategy
implements ExecutionStrategy {
    private final PingRequestBuilder.Callback callback;
    private final RpcClient<PingRequestDTO, PingResponseDTO> client;
    private int numberOfRequests;

    public MultiplePingExecutionStrategy(RpcClient<PingRequestDTO, PingResponseDTO> client, int numberOfRequests, PingRequestBuilder.Callback callback) {
        this.client = Objects.requireNonNull(client);
        this.numberOfRequests = numberOfRequests;
        this.callback = Objects.requireNonNull(callback);
    }

    @Override
    public CompletableFuture<PingSummary> execute(PingRequestDTO requestDTO) {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        PingSummary overallPingSummary = new PingSummary(requestDTO.toPingRequest(), this.numberOfRequests);
        CompletableFuture<PingSummary> overallFuture = CompletableFuture.supplyAsync(() -> {
            for (int sequenceId = 1; sequenceId <= this.numberOfRequests; ++sequenceId) {
                PingSequence newSequence;
                this.reportProgress(null, overallPingSummary);
                CompletableFuture<PingSummary> singlePingResponse = new SinglePingExecutionStrategy(this.client).execute(requestDTO);
                try {
                    PingSummary singleSummary = singlePingResponse.get(requestDTO.getTimeToLiveMs(), TimeUnit.MILLISECONDS);
                    newSequence = new PingSequence(sequenceId, singleSummary.getSequence(0).getResponse());
                    overallPingSummary.addSequence(newSequence);
                    this.reportProgress(newSequence, overallPingSummary);
                    continue;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    newSequence = new PingSequence(sequenceId, e);
                    overallPingSummary.addSequence(newSequence);
                    this.reportProgress(newSequence, overallPingSummary);
                }
            }
            return overallPingSummary;
        }, executor);
        return overallFuture;
    }

    private void reportProgress(PingSequence newSequence, PingSummary summary) {
        if (this.callback != null) {
            this.callback.onUpdate(newSequence, summary);
        }
    }
}

