/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.jmx.connection.JmxConnectionManager;
import org.opennms.netmgt.jmx.connection.JmxConnectors;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.connection.JmxServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.JBossMBeanServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.JMXSecureMBeanServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.Jsr160MBeanServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.MX4JMBeanServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.PlatformMBeanServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionManager
implements JmxConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnectionManager.class);
    private static final JmxConnectionManager.RetryCallback NULL_CALLBACK = new JmxConnectionManager.RetryCallback(){

        public void onRetry() {
        }
    };
    private final Map<JmxConnectors, JmxServerConnector> connectorMap = new HashMap<JmxConnectors, JmxServerConnector>();
    private final int retries;

    public DefaultConnectionManager(int retryCount) {
        this.retries = retryCount <= 0 ? 3 : retryCount;
        this.connectorMap.put(JmxConnectors.jsr160, new Jsr160MBeanServerConnector());
        this.connectorMap.put(JmxConnectors.mx4j, new MX4JMBeanServerConnector());
        this.connectorMap.put(JmxConnectors.jboss, new JBossMBeanServerConnector());
        this.connectorMap.put(JmxConnectors.jmx_secure, new JMXSecureMBeanServerConnector());
        this.connectorMap.put(JmxConnectors.platform, new PlatformMBeanServerConnector());
    }

    public DefaultConnectionManager() {
        this(1);
    }

    public JmxServerConnectionWrapper connect(JmxConnectors connectorName, InetAddress ipAddress, Map<String, String> properties, JmxConnectionManager.RetryCallback retryCallback) throws JmxServerConnectionException {
        if (retryCallback == null) {
            retryCallback = NULL_CALLBACK;
        }
        JmxServerConnectionException lastException = null;
        JmxServerConnector connector = this.getConnector(connectorName);
        for (int i = 0; i < this.retries; ++i) {
            LOG.debug("{}/{}: Try connecting to {}", new Object[]{i + 1, this.retries, ipAddress});
            retryCallback.onRetry();
            try {
                JmxServerConnectionWrapper connectionWrapper = connector.createConnection(ipAddress, properties);
                if (connectionWrapper == null) {
                    throw new JmxServerConnectionException("Received null connection");
                }
                return connectionWrapper;
            }
            catch (JmxServerConnectionException ex) {
                LOG.debug("Connection could not be established", (Throwable)ex);
                lastException = ex;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new JmxServerConnectionException("Connection could not be established. Reason: No retries left.");
    }

    public JmxServerConnector getConnector(JmxConnectors connectorName) throws JmxServerConnectionException {
        if (!this.connectorMap.containsKey(connectorName)) {
            throw new JmxServerConnectionException("No Connector available for connection name '" + connectorName + "'");
        }
        JmxServerConnector connector = this.connectorMap.get(connectorName);
        return connector;
    }
}

