/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.xml;

import java.util.Objects;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.xml.XmlHandler;

public abstract class AbstractXmlRpcModule<S extends RpcRequest, T extends RpcResponse>
implements RpcModule<S, T> {
    private final Class<S> requestClazz;
    private final Class<T> responseClazz;
    private final ThreadLocal<XmlHandler<S>> requestXmlHandler = new ThreadLocal();
    private final ThreadLocal<XmlHandler<T>> responseXmlHandler = new ThreadLocal();

    public AbstractXmlRpcModule(Class<S> requestClazz, Class<T> responseClazz) {
        this.requestClazz = Objects.requireNonNull(requestClazz);
        this.responseClazz = Objects.requireNonNull(responseClazz);
    }

    public String marshalRequest(S request) {
        return this.getRequestXmlHandler().marshal(request);
    }

    public S unmarshalRequest(String requestXml) {
        return (S)((RpcRequest)this.getRequestXmlHandler().unmarshal(requestXml));
    }

    public String marshalResponse(T response) {
        return this.getResponseXmlHandler().marshal(response);
    }

    public T unmarshalResponse(String response) {
        return (T)((RpcResponse)this.getResponseXmlHandler().unmarshal(response));
    }

    private XmlHandler<S> getRequestXmlHandler() {
        XmlHandler<S> xmlHandler = this.requestXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.requestClazz);
            this.requestXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private XmlHandler<T> getResponseXmlHandler() {
        XmlHandler<T> xmlHandler = this.responseXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.responseClazz);
            this.responseXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private <W> XmlHandler<W> createXmlHandler(Class<W> clazz) {
        try {
            return new XmlHandler(clazz);
        }
        catch (Throwable t) {
            return new XmlHandler(clazz);
        }
    }
}

