/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.config.mailtransporttest.ReadmailTest;
import org.opennms.netmgt.config.mailtransporttest.SendmailTest;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.MailTransportParameters;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class MailTransportMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MailTransportMonitor.class);
    private static final String MTM_HEADER_KEY = "X-OpenNMS-MTM-ID";
    private final String m_headerValue = Integer.toString(new Random().nextInt(Integer.MAX_VALUE));

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = null;
        try {
            MailTransportParameters mailParms = MailTransportParameters.get(parameters);
            try {
                if ("${ipaddr}".equals(mailParms.getReadTestHost())) {
                    mailParms.setReadTestHost(svc.getIpAddr());
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                if ("${ipaddr}".equals(mailParms.getSendTestHost())) {
                    mailParms.setSendTestHost(svc.getIpAddr());
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.parseJavaMailProperties(mailParms);
            status = this.doMailTest(mailParms);
        }
        catch (IllegalStateException mailParms) {
        }
        catch (Throwable e) {
            LOG.error("An error occurred while polling.", e);
            status = PollStatus.down((String)("Exception from mailer: " + e.getLocalizedMessage()));
        }
        return status;
    }

    private void parseJavaMailProperties(MailTransportParameters mailParms) {
        SendmailTest sendTest;
        ReadmailTest readTest = mailParms.getReadTest();
        List propertyList = new ArrayList();
        if (readTest != null) {
            propertyList = readTest.getJavamailPropertyCollection();
        }
        if ((sendTest = mailParms.getSendTest()) != null) {
            List sendTestProperties = sendTest.getJavamailPropertyCollection();
            propertyList.addAll(sendTestProperties);
        }
        Properties props = mailParms.getJavamailProperties();
        for (JavamailProperty property : propertyList) {
            props.setProperty(property.getName(), property.getValue());
        }
        mailParms.setJavamailProperties(props);
    }

    private PollStatus doMailTest(MailTransportParameters mailParms) {
        long beginPoll = System.currentTimeMillis();
        PollStatus status = PollStatus.unknown((String)"Beginning poll.");
        mailParms.setTestSubjectSuffix(Long.toString(beginPoll));
        if (mailParms.getSendTest() != null && mailParms.getReadTest() != null) {
            mailParms.setEnd2EndTestInProgress(true);
            status = this.sendTestMessage(mailParms);
            if (status.isAvailable()) {
                LOG.debug("doMailTest: send test successful.");
                status = this.readTestMessage(mailParms);
            } else {
                LOG.info("doMailTest: send test unsuccessful... skipping read portion of test.");
            }
        } else if (mailParms.getReadTest() != null) {
            status = this.readTestMessage(mailParms);
        } else if (mailParms.getSendTest() != null) {
            status = this.sendTestMessage(mailParms);
        } else {
            throw new IllegalArgumentException("MailTransportMonitor requires either send-host or read-host parameters");
        }
        if (status.isAvailable()) {
            status.setResponseTime(Double.valueOf(String.valueOf(System.currentTimeMillis() - beginPoll)));
        }
        LOG.info("doMailTest: mailtest result: {}", (Object)status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollStatus readTestMessage(MailTransportParameters mailParms) {
        LOG.debug("readTestMessage: Beginning read mail test.");
        PollStatus status = PollStatus.unavailable((String)"Test not completed.");
        long interval = mailParms.getReadTestAttemptInterval();
        if (mailParms.isEnd2EndTestInProgress()) {
            LOG.debug("Initially delaying read test: {} because end to end test is in progress.", (Object)mailParms.getReadTestAttemptInterval());
            if (this.delayTest(status, interval) == 0) {
                return status;
            }
        }
        Store mailStore = null;
        Folder mailFolder = null;
        try {
            JavaMailer readMailer = new JavaMailer(mailParms.getJavamailProperties());
            this.setReadMailProperties(mailParms, readMailer);
            TimeoutTracker tracker = new TimeoutTracker(mailParms.getParameterMap(), mailParms.getRetries(), mailParms.getTimeout());
            tracker.reset();
            while (tracker.shouldRetry()) {
                block15: {
                    tracker.startAttempt();
                    if (tracker.getAttempt() > 0 && this.delayTest(status, interval) == 0) {
                        LOG.warn("readTestMessage: Status set to: {} during delay, exiting test.", (Object)status);
                        break;
                    }
                    LOG.debug("readTestMessage: reading mail attempt: {}, elapsed time: {}ms.", (Object)(tracker.getAttempt() + 1), (Object)String.format("%.2f", tracker.elapsedTimeInMillis()));
                    try {
                        mailStore = readMailer.getSession().getStore();
                        mailFolder = this.retrieveMailFolder(mailParms, mailStore);
                        mailFolder.open(2);
                    }
                    catch (MessagingException e) {
                        if (tracker.shouldRetry()) {
                            LOG.warn("readTestMessage: error reading INBOX", (Throwable)e);
                            this.closeStore(mailStore, mailFolder);
                            break block15;
                        }
                        LOG.warn("readTestMessage: error reading INBOX", (Throwable)e);
                        PollStatus pollStatus = PollStatus.down((String)e.getLocalizedMessage());
                        this.closeStore(mailStore, mailFolder);
                        return pollStatus;
                    }
                    if (mailFolder.isOpen() && (mailParms.getReadTest().getSubjectMatch() != null || mailParms.isEnd2EndTestInProgress()) && (status = this.processMailSubject(mailParms, mailFolder)).getStatusCode() == 1) {
                        break;
                    }
                }
                tracker.nextAttempt();
            }
        }
        catch (JavaMailerException e) {
            status = PollStatus.down((String)e.getLocalizedMessage());
        }
        finally {
            this.closeStore(mailStore, mailFolder);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(Store mailStore, Folder mailFolder) {
        try {
            if (mailFolder != null && mailFolder.isOpen()) {
                mailFolder.close(true);
            }
        }
        catch (MessagingException e) {
            LOG.debug("Unable to close mail folder.", (Throwable)e);
        }
        finally {
            try {
                if (mailStore != null && mailStore.isConnected()) {
                    mailStore.close();
                }
            }
            catch (MessagingException e1) {
                LOG.debug("Unable to close message store.", (Throwable)e1);
            }
        }
    }

    private PollStatus processMailSubject(MailTransportParameters mailParms, Folder mailFolder) {
        PollStatus status = PollStatus.unknown();
        try {
            String subject = this.computeMatchingSubject(mailParms);
            if (mailFolder.isOpen() && subject != null) {
                Message[] mailMessages = mailFolder.getMessages();
                SubjectTerm searchTerm = new SubjectTerm(subject);
                HeaderTerm deleteTerm = new HeaderTerm(MTM_HEADER_KEY, this.m_headerValue);
                LOG.debug("searchMailSubject: searching {} message(s) for subject '{}'", (Object)mailMessages.length, (Object)subject);
                boolean delete = false;
                boolean found = false;
                for (int i = 1; i <= mailMessages.length; ++i) {
                    Message mailMessage = mailFolder.getMessage(i);
                    LOG.debug("searchMailSubject: retrieved message subject '{}'", (Object)mailMessage.getSubject());
                    if (mailMessage.match((SearchTerm)searchTerm)) {
                        found = true;
                        LOG.debug("searchMailSubject: message with subject '{}' found.", (Object)subject);
                        if (mailParms.isEnd2EndTestInProgress()) {
                            if (!delete) {
                                LOG.debug("searchMailSubject: flagging message with subject '{}' for deletion for end2end test.", (Object)subject);
                            }
                            delete = true;
                        }
                    }
                    boolean deleteAllMail = mailParms.getReadTest().isDeleteAllMail();
                    boolean foundMTMHeader = mailMessage.match((SearchTerm)deleteTerm);
                    LOG.debug("searchMailSubject: deleteAllMail = {}, MTM header found = {}", (Object)Boolean.toString(deleteAllMail), (Object)Boolean.toString(foundMTMHeader));
                    if (deleteAllMail) {
                        if (!delete) {
                            LOG.debug("searchMailSubject: flagging message with subject '{}' for deletion because deleteAllMail is set.", (Object)subject);
                        }
                        delete = true;
                    } else if (foundMTMHeader) {
                        if (!delete) {
                            LOG.debug("searchMailSubject: flagging message with subject '{}' for deletion because we sent it (found header {}={})", new Object[]{subject, MTM_HEADER_KEY, this.m_headerValue});
                        }
                        delete = true;
                    }
                    if (!delete) continue;
                    mailMessage.setFlag(Flags.Flag.DELETED, true);
                }
                if (!found) {
                    LOG.debug("searchMailSubject: message with subject: '{}' NOT found.", (Object)subject);
                    status = PollStatus.down((String)("searchMailSubject: matching test message: '" + subject + "', not found."));
                } else {
                    status = PollStatus.available();
                }
            }
        }
        catch (MessagingException e) {
            return PollStatus.down((String)e.getLocalizedMessage());
        }
        return status;
    }

    private String computeMatchingSubject(MailTransportParameters mailParms) {
        String subject = null;
        subject = mailParms.isEnd2EndTestInProgress() ? mailParms.getComputedTestSubject() : mailParms.getReadTest().getSubjectMatch();
        return subject;
    }

    private void setReadMailProperties(MailTransportParameters mailParms, JavaMailer readMailer) {
        Properties sendMailProps = readMailer.getSession().getProperties();
        String protocol = mailParms.getReadTestProtocol();
        sendMailProps.put("mail." + protocol + ".host", mailParms.getReadTestHost());
        sendMailProps.put("mail." + protocol + ".user", mailParms.getReadTestUserName());
        sendMailProps.put("mail." + protocol + ".port", (Object)mailParms.getReadTestPort());
        sendMailProps.put("mail." + protocol + ".starttls.enable", (Object)mailParms.isReadTestStartTlsEnabled());
        sendMailProps.put("mail.smtp.auth", "true");
        if (mailParms.isReadTestSslEnabled()) {
            sendMailProps.put("mail." + protocol + ".socketFactory.port", (Object)mailParms.getReadTestPort());
            sendMailProps.put("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            sendMailProps.put("mail." + protocol + ".socketFactory.fallback", "false");
        }
        sendMailProps.put("mail." + protocol + ".connectiontimeout", (Object)mailParms.getTimeout());
        sendMailProps.put("mail." + protocol + ".timeout", (Object)mailParms.getTimeout());
        sendMailProps.put("mail.store.protocol", protocol);
    }

    private Folder retrieveMailFolder(MailTransportParameters mailParms, Store mailStore) throws MessagingException {
        mailStore.connect(mailParms.getReadTestHost(), mailParms.getReadTestPort(), mailParms.getReadTestUserName(), mailParms.getReadTestPassword());
        Folder mailFolder = mailStore.getDefaultFolder();
        mailFolder = mailFolder.getFolder(mailParms.getReadTestFolder());
        return mailFolder;
    }

    private PollStatus sendTestMessage(MailTransportParameters mailParms) {
        PollStatus status = PollStatus.unavailable((String)"Test not completed.");
        long interval = mailParms.getSendTestAttemptInterval();
        TimeoutTracker tracker = new TimeoutTracker(mailParms.getParameterMap(), mailParms.getRetries(), mailParms.getTimeout());
        tracker.reset();
        while (tracker.shouldRetry()) {
            tracker.startAttempt();
            LOG.debug("sendTestMessage: sending mail attempt: {}, elapsed time: {}ms", (Object)(tracker.getAttempt() + 1), (Object)String.format("%.2f", tracker.elapsedTimeInMillis()));
            try {
                JavaMailer sendMailer = this.createMailer(mailParms);
                this.overRideDefaultProperties(mailParms, sendMailer);
                sendMailer.mailSend();
                status = PollStatus.available();
                break;
            }
            catch (JavaMailerException e) {
                status = PollStatus.unavailable((String)e.getLocalizedMessage());
                if (tracker.shouldRetry()) {
                    this.delayTest(status, interval);
                }
                tracker.nextAttempt();
            }
        }
        return status;
    }

    private int delayTest(PollStatus status, long interval) {
        LOG.debug("delayTest: delaying test for: {}ms. per configuration.", (Object)interval);
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            LOG.error("delayTest: An interrupt exception occurred while delaying the mail test", (Throwable)e);
            status = PollStatus.unknown((String)e.getLocalizedMessage());
        }
        return status.getStatusCode();
    }

    private void overRideDefaultProperties(MailTransportParameters mailParms, JavaMailer sendMailer) {
        sendMailer.setFrom(mailParms.getSendTestFrom());
        sendMailer.getSession().setDebug(mailParms.isSendTestDebug());
        sendMailer.setDebug(mailParms.isSendTestDebug());
        sendMailer.setEncoding(mailParms.getSendTestMessageEncoding());
        sendMailer.setMailer(mailParms.getSendTestMailer());
        sendMailer.setMailHost(mailParms.getSendTestHost());
        sendMailer.setMessageText(mailParms.getSendTestMessageBody());
        sendMailer.setCharSet(mailParms.getSendTestCharSet());
        sendMailer.setContentType(mailParms.getSendTestMessageContentType());
        sendMailer.setSmtpSsl(mailParms.isSendTestIsSslEnable());
        sendMailer.setSubject(mailParms.getComputedTestSubject());
        sendMailer.setTo(mailParms.getSendTestRecipeint());
        sendMailer.setTransport(mailParms.getSendTestTransport());
        sendMailer.setUseJMTA(mailParms.isSendTestUseJmta());
    }

    private JavaMailer createMailer(MailTransportParameters mailParms) throws JavaMailerException {
        JavaMailer sendMailer = new JavaMailer(mailParms.getJavamailProperties());
        String mailPropsPrefix = "mail." + mailParms.getSendTestTransport() + '.';
        Properties props = sendMailer.getSession().getProperties();
        props.setProperty(mailPropsPrefix + "user", mailParms.getSendTestUserName());
        sendMailer.setUser(mailParms.getSendTestUserName());
        sendMailer.setPassword(mailParms.getSendTestPassword());
        props.setProperty(mailPropsPrefix + "host", mailParms.getSendTestHost());
        sendMailer.setMailHost(mailParms.getSendTestHost());
        props.setProperty(mailPropsPrefix + "port", String.valueOf(mailParms.getSendTestPort()));
        sendMailer.setSmtpPort(mailParms.getSendTestPort());
        if (!props.containsKey(mailPropsPrefix + "connectiontimeout")) {
            props.setProperty(mailPropsPrefix + "connectiontimeout", String.valueOf(mailParms.getTimeout()));
        }
        if (!props.containsKey(mailPropsPrefix + "timeout")) {
            props.setProperty(mailPropsPrefix + "timeout", String.valueOf(mailParms.getTimeout()));
        }
        props.setProperty(mailPropsPrefix + "from", mailParms.getSendTestFrom());
        sendMailer.setFrom(mailParms.getSendTestFrom());
        props.setProperty(mailPropsPrefix + "auth", String.valueOf(mailParms.isSendTestUseAuth()));
        sendMailer.setAuthenticate(mailParms.isSendTestUseAuth());
        props.setProperty(mailPropsPrefix + "quitwait", String.valueOf(mailParms.isSendTestIsQuitWait()));
        sendMailer.setQuitWait(mailParms.isSendTestIsQuitWait());
        if (mailParms.isSendTestIsSslEnable()) {
            if (!props.containsKey(mailPropsPrefix + "socketFactory.class")) {
                props.setProperty(mailPropsPrefix + "socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.setProperty(mailPropsPrefix + "socketFactory.port", String.valueOf(mailParms.getSendTestPort()));
            sendMailer.setSmtpPort(mailParms.getSendTestPort());
        }
        sendMailer.setSmtpSsl(mailParms.isSendTestIsSslEnable());
        props.setProperty(mailPropsPrefix + "starttls.enable", String.valueOf(mailParms.isSendTestStartTls()));
        sendMailer.setStartTlsEnabled(mailParms.isSendTestStartTls());
        sendMailer.addExtraHeader(MTM_HEADER_KEY, this.m_headerValue);
        sendMailer.setSession(Session.getInstance((Properties)props, (Authenticator)sendMailer.createAuthenticator()));
        return sendMailer;
    }
}

