/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;

public class CamelRpcServerProcessor
implements AsyncProcessor {
    private final RpcModule<RpcRequest, RpcResponse> module;

    public CamelRpcServerProcessor(RpcModule<RpcRequest, RpcResponse> module) {
        this.module = Objects.requireNonNull(module);
    }

    public void process(Exchange exchange) {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        RpcRequest request = this.module.unmarshalRequest((String)exchange.getIn().getBody(String.class));
        CompletableFuture future = this.module.execute(request);
        future.whenComplete((res, ex) -> {
            try {
                if (ex != null) {
                    exchange.setException(ex);
                    exchange.getOut().setFault(true);
                } else {
                    try {
                        exchange.getOut().setBody((Object)this.module.marshalResponse(res), String.class);
                    }
                    catch (Throwable t) {
                        exchange.setException(t);
                        exchange.getOut().setFault(true);
                    }
                }
            }
            finally {
                callback.done(false);
            }
        });
        return false;
    }
}

