/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcAddResponse;
import com.novell.ldap.rfc2251.RfcBindResponse;
import com.novell.ldap.rfc2251.RfcCompareResponse;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcDelResponse;
import com.novell.ldap.rfc2251.RfcExtendedResponse;
import com.novell.ldap.rfc2251.RfcIntermediateResponse;
import com.novell.ldap.rfc2251.RfcMessageID;
import com.novell.ldap.rfc2251.RfcModifyDNResponse;
import com.novell.ldap.rfc2251.RfcModifyResponse;
import com.novell.ldap.rfc2251.RfcRequest;
import com.novell.ldap.rfc2251.RfcSearchResultDone;
import com.novell.ldap.rfc2251.RfcSearchResultEntry;
import com.novell.ldap.rfc2251.RfcSearchResultReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RfcLDAPMessage
extends ASN1Sequence {
    private ASN1Object op;
    private RfcControls controls;
    private LDAPMessage requestMessage = null;

    RfcLDAPMessage(ASN1Object[] aSN1ObjectArray, RfcRequest rfcRequest, String string, String string2, boolean bl) throws LDAPException {
        super(aSN1ObjectArray, aSN1ObjectArray.length);
        this.set(0, new RfcMessageID());
        RfcRequest rfcRequest2 = (RfcRequest)((Object)aSN1ObjectArray[1]);
        RfcRequest rfcRequest3 = rfcRequest2.dupRequest(string, string2, bl);
        this.op = (ASN1Object)((Object)rfcRequest3);
        this.set(1, (ASN1Object)((Object)rfcRequest3));
    }

    public RfcLDAPMessage(RfcRequest rfcRequest) {
        this(rfcRequest, null);
    }

    public RfcLDAPMessage(RfcRequest rfcRequest, RfcControls rfcControls) {
        super(3);
        this.op = (ASN1Object)((Object)rfcRequest);
        this.controls = rfcControls;
        this.add(new RfcMessageID());
        this.add((ASN1Object)((Object)rfcRequest));
        if (rfcControls != null) {
            this.add(rfcControls);
        }
    }

    public RfcLDAPMessage(ASN1Sequence aSN1Sequence) {
        this(aSN1Sequence, null);
    }

    public RfcLDAPMessage(ASN1SequenceOf aSN1SequenceOf) {
        super(2);
        this.op = aSN1SequenceOf;
        this.add(new RfcMessageID());
        this.add(aSN1SequenceOf);
    }

    public RfcLDAPMessage(ASN1Sequence aSN1Sequence, RfcControls rfcControls) {
        super(3);
        this.op = aSN1Sequence;
        this.controls = rfcControls;
        this.add(new RfcMessageID());
        this.add(aSN1Sequence);
        if (rfcControls != null) {
            this.add(rfcControls);
        }
    }

    public RfcLDAPMessage(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        super(aSN1Decoder, inputStream, n);
        ASN1Tagged aSN1Tagged = (ASN1Tagged)this.get(1);
        ASN1Identifier aSN1Identifier = aSN1Tagged.getIdentifier();
        byte[] byArray = ((ASN1OctetString)aSN1Tagged.taggedValue()).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        switch (aSN1Identifier.getTag()) {
            case 4: {
                this.set(1, new RfcSearchResultEntry(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 5: {
                this.set(1, new RfcSearchResultDone(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 19: {
                this.set(1, new RfcSearchResultReference(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 9: {
                this.set(1, new RfcAddResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 1: {
                this.set(1, new RfcBindResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 15: {
                this.set(1, new RfcCompareResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 11: {
                this.set(1, new RfcDelResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 24: {
                this.set(1, new RfcExtendedResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 25: {
                this.set(1, new RfcIntermediateResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 7: {
                this.set(1, new RfcModifyResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            case 13: {
                this.set(1, new RfcModifyDNResponse(aSN1Decoder, byteArrayInputStream, byArray.length));
                break;
            }
            default: {
                throw new RuntimeException("RfcLDAPMessage: Invalid tag: " + aSN1Identifier.getTag());
            }
        }
        if (this.size() > 2) {
            ASN1Tagged aSN1Tagged2 = (ASN1Tagged)this.get(2);
            byArray = ((ASN1OctetString)aSN1Tagged2.taggedValue()).byteValue();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.set(2, new RfcControls(aSN1Decoder, byteArrayInputStream, byArray.length));
        }
    }

    public final int getMessageID() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public final int getType() {
        return this.get(1).getIdentifier().getTag();
    }

    public final ASN1Object getResponse() {
        return this.get(1);
    }

    public final RfcRequest getRequest() {
        return (RfcRequest)((Object)this.get(1));
    }

    public boolean isRequest() {
        return this.get(1) instanceof RfcRequest;
    }

    public final RfcControls getControls() {
        if (this.size() > 2) {
            return (RfcControls)this.get(2);
        }
        return null;
    }

    public final Object dupMessage(String string, String string2, boolean bl) throws LDAPException {
        if (this.op == null) {
            throw new LDAPException("DUP_ERROR", 82, null);
        }
        RfcLDAPMessage rfcLDAPMessage = new RfcLDAPMessage(this.toArray(), (RfcRequest)((Object)this.get(1)), string, string2, bl);
        return rfcLDAPMessage;
    }

    public final String getRequestDN() {
        return ((RfcRequest)((Object)this.op)).getRequestDN();
    }

    public final void setRequestingMessage(LDAPMessage lDAPMessage) {
        this.requestMessage = lDAPMessage;
    }

    public final LDAPMessage getRequestingMessage() {
        return this.requestMessage;
    }
}

