/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.proxy.ProxiableTracker;

public abstract class CollectionTracker
implements Collectable,
ProxiableTracker {
    public static final int NO_ERR = 0;
    public static final int TOO_BIG_ERR = 1;
    public static final int NO_SUCH_NAME_ERR = 2;
    public static final int GEN_ERR = 5;
    private CollectionTracker m_parent;
    private boolean m_failed = false;
    private boolean m_timedOut = false;
    private boolean m_finished = false;

    public CollectionTracker() {
        this(null);
    }

    public CollectionTracker(CollectionTracker parent) {
        this.m_parent = parent;
    }

    public void setParent(CollectionTracker parent) {
        this.m_parent = parent;
    }

    public CollectionTracker getParent() {
        return this.m_parent;
    }

    public boolean failed() {
        return this.m_failed || this.m_timedOut;
    }

    public boolean timedOut() {
        return this.m_timedOut;
    }

    public abstract void setMaxRepetitions(int var1);

    public void setFailed(boolean failed) {
        this.m_failed = failed;
    }

    public void setTimedOut(boolean timedOut) {
        this.m_timedOut = timedOut;
    }

    protected void storeResult(SnmpResult res) {
        if (this.m_parent != null) {
            this.m_parent.storeResult(res);
        }
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public final void setFinished(boolean finished) {
        this.m_finished = finished;
    }

    public abstract ResponseProcessor buildNextPdu(PduBuilder var1);

    protected void reportTooBigErr(String msg) {
        if (this.m_parent != null) {
            this.m_parent.reportTooBigErr(msg);
        }
    }

    protected void reportGenErr(String msg) {
        if (this.m_parent != null) {
            this.m_parent.reportGenErr(msg);
        }
    }

    protected void reportNoSuchNameErr(String msg) {
        if (this.m_parent != null) {
            this.m_parent.reportNoSuchNameErr(msg);
        }
    }

    @Override
    public CollectionTracker getCollectionTracker() {
        return this;
    }
}

