/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrapInformation
implements TrapNotification,
Serializable {
    private static final long serialVersionUID = -730398590817240290L;
    private static final transient Logger LOG = LoggerFactory.getLogger(TrapInformation.class);
    private final InetAddress m_agent;
    private final String m_community;
    private final long m_creationTime = new Date().getTime();
    private TrapProcessor m_trapProcessor;

    protected TrapInformation(InetAddress agent, String community, TrapProcessor trapProcessor) {
        this.m_agent = agent;
        this.m_community = community;
        this.m_trapProcessor = trapProcessor;
    }

    protected abstract InetAddress getTrapAddress();

    protected InetAddress getAgent() {
        return this.m_agent;
    }

    protected String getCommunity() {
        return this.m_community;
    }

    protected void validate() {
    }

    protected InetAddress getAgentAddress() {
        return this.getAgent();
    }

    protected final long getCreationTime() {
        return this.m_creationTime;
    }

    @Override
    public final TrapProcessor getTrapProcessor() {
        return TrapInformation.processTrap(this, this.m_trapProcessor);
    }

    @Override
    public final void setTrapProcessor(TrapProcessor trapProcessor) {
        this.m_trapProcessor = trapProcessor;
    }

    protected abstract String getVersion();

    protected abstract int getPduLength();

    protected abstract long getTimeStamp();

    protected abstract TrapIdentity getTrapIdentity();

    protected static TrapProcessor processTrap(TrapInformation trap, TrapProcessor trapProcessor) {
        trap.validate();
        trapProcessor.setCreationTime(trap.getCreationTime());
        trapProcessor.setVersion(trap.getVersion());
        trapProcessor.setCommunity(trap.getCommunity());
        trapProcessor.setAgentAddress(trap.getAgentAddress());
        trapProcessor.setTrapAddress(trap.getTrapAddress());
        LOG.debug("{} trap - trapInterface: ()", (Object)trap.getVersion(), (Object)trap.getTrapAddress());
        trapProcessor.setTimeStamp(trap.getTimeStamp());
        trapProcessor.setTrapIdentity(trap.getTrapIdentity());
        for (int i = 0; i < trap.getPduLength(); ++i) {
            trap.processVarBindAt(i);
        }
        return trapProcessor;
    }

    protected abstract void processVarBindAt(int var1);

    protected void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_trapProcessor.processVarBind(name, value);
    }
}

