/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.IpAddress;

public class IpAddressBadLengthBugAware
extends IpAddress {
    private static final transient Logger LOG = LoggerFactory.getLogger(IpAddressBadLengthBugAware.class);
    private static final long serialVersionUID = -5736688810851346588L;

    public IpAddressBadLengthBugAware() {
    }

    public IpAddressBadLengthBugAware(InetAddress address) {
        super(address);
    }

    public IpAddressBadLengthBugAware(String address) {
        super(address);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] value = BER.decodeString((BERInputStream)inputStream, (BER.MutableByte)type);
        if (type.getValue() != 64) {
            throw new IOException("Wrong type encountered when decoding IpAddress: " + type.getValue());
        }
        if (value.length != 4) {
            if (value.length != 8 || !Boolean.getBoolean("org.opennms.snmp.workarounds.allow64BitIpAddress")) throw new IOException("IpAddress encoding error, wrong length: " + value.length);
            byte[] tempValue = new byte[4];
            System.arraycopy(value, 0, tempValue, 0, 4);
            value = tempValue;
            LOG.debug("Working around misencoded IpAddress (8 bytes, truncating to 4); likely dealing with a buggy Net-SNMP agent");
        } else if (value.length == 0 && Boolean.getBoolean("org.opennms.snmp.workarounds.allowZeroLengthIpAddress")) {
            byte[] tempValue = new byte[]{0, 0, 0, 0};
            value = tempValue;
            LOG.debug("Working around misencoded IpAddress (0 bytes, substituting 0.0.0.0); likely dealing with a buggy DrayTek Vigor2820 Series router");
        }
        this.setInetAddress(InetAddress.getByAddress(value));
    }
}

