/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.WSURI;
import org.eclipse.jetty.websocket.servlet.UpgradeHttpServletRequest;

public class ServletUpgradeRequest
extends UpgradeRequest {
    private final UpgradeHttpServletRequest request;

    public ServletUpgradeRequest(HttpServletRequest httpRequest) throws URISyntaxException {
        super(WSURI.toWebsocket((CharSequence)httpRequest.getRequestURL(), (String)httpRequest.getQueryString()));
        this.request = new UpgradeHttpServletRequest(httpRequest);
        Enumeration<String> requestProtocols = this.request.getHeaders("Sec-WebSocket-Protocol");
        if (requestProtocols != null) {
            ArrayList protocols = new ArrayList(2);
            while (requestProtocols.hasMoreElements()) {
                String candidate = requestProtocols.nextElement();
                Collections.addAll(protocols, this.parseProtocols(candidate));
            }
            this.setSubProtocols(protocols);
        }
        Enumeration<String> e = this.request.getHeaders("Sec-WebSocket-Extensions");
        this.setExtensions(ExtensionConfig.parseEnum(e));
        Cookie[] requestCookies = this.request.getCookies();
        if (requestCookies != null) {
            ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
            for (Cookie requestCookie : requestCookies) {
                HttpCookie cookie = new HttpCookie(requestCookie.getName(), requestCookie.getValue());
                cookies.add(cookie);
            }
            this.setCookies(cookies);
        }
        this.setHeaders(this.request.getHeaders());
        Map<String, String[]> requestParams = this.request.getParameterMap();
        if (requestParams != null) {
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(requestParams.size());
            for (Map.Entry<String, String[]> entry : requestParams.entrySet()) {
                params.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
            }
            this.setParameterMap(params);
        }
        this.setSession(this.request.getSession(false));
        this.setHttpVersion(this.request.getProtocol());
        this.setMethod(this.request.getMethod());
    }

    public X509Certificate[] getCertificates() {
        return (X509Certificate[])this.request.getAttribute("javax.servlet.request.X509Certificate");
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public String getLocalAddress() {
        return this.request.getLocalAddr();
    }

    public String getLocalHostName() {
        return this.request.getLocalName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public InetSocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    @Deprecated
    public Principal getPrincipal() {
        return this.getUserPrincipal();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHostName() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return new InetSocketAddress(this.getRemoteAddress(), this.getRemotePort());
    }

    public Map<String, Object> getServletAttributes() {
        return this.request.getAttributes();
    }

    public Map<String, List<String>> getServletParameters() {
        return this.getParameterMap();
    }

    public HttpSession getSession() {
        return this.request.getSession(false);
    }

    public void setServletAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Object getServletAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public String getRequestPath() {
        String contextPath = this.request.getContextPath();
        String requestPath = this.request.getRequestURI();
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }

    private String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[0];
        }
        if ((protocol = protocol.trim()).length() == 0) {
            return new String[0];
        }
        return protocol.split("\\s*,\\s*");
    }

    public void complete() {
        this.request.complete();
    }
}

