/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.jradius.exception.RadiusException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.attribute.Attr_UnknownAttribute;
import net.jradius.packet.attribute.Attr_UnknownVSAttribute;
import net.jradius.packet.attribute.AttributeDescription;
import net.jradius.packet.attribute.AttributeDictionary;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSADictionary;
import net.jradius.packet.attribute.VSAWithSubAttributes;
import net.jradius.packet.attribute.VSAttribute;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeFactory {
    private static LinkedHashMap<Long, Class<?>> attributeMap = new LinkedHashMap();
    private static LinkedHashMap<Long, Class<?>> vendorMap = new LinkedHashMap();
    private static LinkedHashMap<Long, VendorValue> vendorValueMap = new LinkedHashMap();
    private static LinkedHashMap<String, Class<?>> attributeNameMap = new LinkedHashMap();
    private static KeyedObjectPool attributeObjectPool = new GenericKeyedObjectPool(new KeyedPoolableObjectFactory(){

        public boolean validateObject(Object arg0, Object arg1) {
            return true;
        }

        public void passivateObject(Object arg0, Object arg1) throws Exception {
            RadiusAttribute a = (RadiusAttribute)arg1;
            a.recycled = true;
        }

        public Object makeObject(Object arg0) throws Exception {
            RadiusAttribute a = AttributeFactory.newAttribute((Long)arg0);
            a.recycled = false;
            return a;
        }

        public void destroyObject(Object arg0, Object arg1) throws Exception {
        }

        public void activateObject(Object arg0, Object arg1) throws Exception {
            RadiusAttribute a = (RadiusAttribute)arg1;
            a.recycled = false;
        }
    }, -1);

    private static RadiusAttribute vsa(long vendor, long type) throws InstantiationException, IllegalAccessException {
        RadiusAttribute attr = null;
        VendorValue v = vendorValueMap.get(new Long(vendor));
        Class c = null;
        if (v != null) {
            c = (Class)v.typeMap.get(new Long(type));
        }
        if (c != null) {
            attr = (RadiusAttribute)c.newInstance();
        } else {
            RadiusLog.warn("Unknown Vendor Specific Attribute: " + vendor + ":" + type);
            attr = new Attr_UnknownVSAttribute(vendor, type);
        }
        return attr;
    }

    private static RadiusAttribute attr(long type) throws InstantiationException, IllegalAccessException {
        RadiusAttribute attr = null;
        Class<?> c = attributeMap.get(new Long(type));
        if (c != null) {
            attr = (RadiusAttribute)c.newInstance();
        } else {
            RadiusLog.warn("Unknown Attribute: " + type);
            attr = new Attr_UnknownAttribute(type);
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(Long key) throws Exception {
        RadiusAttribute a = null;
        long val = key;
        long vendor = val >> 16;
        long type = val & 0xFFFFL;
        a = vendor != 0L ? AttributeFactory.vsa(vendor, type) : AttributeFactory.attr(type);
        a.recyclable = true;
        return a;
    }

    public static RadiusAttribute newAttribute(Long key, Serializable value) {
        RadiusAttribute attr = null;
        try {
            attr = AttributeFactory.borrow(key);
            if (attr == null) {
                attr = AttributeFactory.newAttribute(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        attr.getValue().setValueObject(value);
        return attr;
    }

    public static RadiusAttribute copyAttribute(RadiusAttribute a) {
        Long key = new Long(a.getFormattedType());
        RadiusAttribute attr = null;
        try {
            attr = AttributeFactory.borrow(key);
            if (attr == null) {
                attr = AttributeFactory.newAttribute(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        attr.getValue().copy(a.getValue());
        return attr;
    }

    public static RadiusAttribute borrow(Long key) throws NoSuchElementException, IllegalStateException, Exception {
        RadiusAttribute attr = null;
        if (attributeObjectPool != null) {
            attr = (RadiusAttribute)attributeObjectPool.borrowObject((Object)key);
        }
        return attr;
    }

    public static boolean loadAttributeDictionary(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            return AttributeFactory.loadAttributeDictionary((AttributeDictionary)o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean loadAttributeDictionary(AttributeDictionary dict) {
        dict.loadAttributes(attributeMap);
        dict.loadAttributesNames(attributeNameMap);
        dict.loadVendorCodes(vendorMap);
        for (Long id : vendorMap.keySet()) {
            Class<?> c = vendorMap.get(id);
            try {
                LinkedHashMap typeMap = new LinkedHashMap();
                LinkedHashMap nameMap = new LinkedHashMap();
                VSADictionary vsadict = (VSADictionary)c.newInstance();
                vsadict.loadAttributes(typeMap);
                vsadict.loadAttributesNames(nameMap);
                vsadict.loadAttributesNames(attributeNameMap);
                vendorValueMap.put(id, new VendorValue(c, typeMap, nameMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static RadiusAttribute attributeFromString(String src) throws RadiusException, UnknownAttributeException {
        String[] parts = src.split("=", 2);
        if (parts.length == 2) {
            String attribute = parts[0].trim();
            String value = parts[1].trim();
            char q = value.charAt(0);
            if (q == value.charAt(value.length() - 1) && (q == '\'' || q == '\"')) {
                value = value.substring(1, value.length() - 1);
            }
            return AttributeFactory.newAttribute(attribute, value, "=");
        }
        throw new RadiusException("Syntax error for attributes: " + src);
    }

    public static void loadAttributesFromString(AttributeList list, String src, String delim, boolean beStrinct) throws RadiusException {
        StringTokenizer st = new StringTokenizer(src, delim);
        while (st.hasMoreTokens()) {
            try {
                list.add(AttributeFactory.attributeFromString(st.nextToken()));
            }
            catch (RadiusException e) {
                if (!beStrinct) continue;
                throw e;
            }
        }
    }

    public static RadiusAttribute newAttribute(long vendor, long type, byte[] value, int op) {
        RadiusAttribute attr = null;
        try {
            if (vendor > 1L || type == 26L) {
                Long key;
                boolean onWire = vendor < 1L;
                DataInputStream input = null;
                if (onWire) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(value);
                    input = new DataInputStream(bais);
                    vendor = RadiusFormat.readUnsignedInt(input);
                    type = RadiusFormat.readUnsignedByte(input);
                }
                if ((attr = AttributeFactory.borrow(key = new Long(vendor << 16 | type))) == null) {
                    attr = AttributeFactory.vsa(vendor, type);
                }
                if (onWire) {
                    VSAttribute vsa = (VSAttribute)attr;
                    int vsaLength = 0;
                    int vsaHeaderLen = 2;
                    switch (vsa.getLengthLength()) {
                        case 1: {
                            vsaLength = RadiusFormat.readUnsignedByte(input);
                            break;
                        }
                        case 2: {
                            vsaLength = RadiusFormat.readUnsignedShort(input);
                            ++vsaHeaderLen;
                            break;
                        }
                        case 4: {
                            vsaLength = (int)RadiusFormat.readUnsignedInt(input);
                            vsaHeaderLen += 3;
                        }
                    }
                    if (vsa.hasContinuationByte) {
                        vsa.continuation = (short)RadiusFormat.readUnsignedByte(input);
                        ++vsaHeaderLen;
                    }
                    byte[] newValue = new byte[vsaLength - vsaHeaderLen];
                    input.readFully(newValue);
                    input.close();
                    value = newValue;
                }
            } else {
                attr = AttributeFactory.borrow(type);
                if (attr == null) {
                    attr = AttributeFactory.attr(type);
                }
            }
            if (value != null) {
                attr.setValue(value);
            } else {
                attr.setValue(new byte[0]);
            }
            if (op > -1) {
                attr.setAttributeOp(op);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(long vendor, long type, long len, int op, ByteBuffer buffer) {
        RadiusAttribute attr = null;
        int valueLength = (int)len;
        try {
            if (vendor > 1L || type == 26L) {
                Long key;
                boolean needVendorType;
                boolean needVendorAndType = vendor < 1L;
                boolean bl = needVendorType = type < 1L;
                if (needVendorAndType) {
                    vendor = RadiusFormat.getUnsignedInt(buffer);
                }
                if (needVendorAndType || needVendorType) {
                    type = RadiusFormat.getUnsignedByte(buffer);
                }
                if ((attr = AttributeFactory.borrow(key = new Long(vendor << 16 | type))) == null) {
                    attr = AttributeFactory.vsa(vendor, type);
                }
                if (needVendorAndType || needVendorType) {
                    VSAttribute vsa = (VSAttribute)attr;
                    int vsaLength = 0;
                    int vsaHeaderLen = 2;
                    switch (vsa.getLengthLength()) {
                        case 1: {
                            vsaLength = RadiusFormat.getUnsignedByte(buffer);
                            break;
                        }
                        case 2: {
                            vsaLength = RadiusFormat.getUnsignedShort(buffer);
                            ++vsaHeaderLen;
                            break;
                        }
                        case 4: {
                            vsaLength = (int)RadiusFormat.getUnsignedInt(buffer);
                            vsaHeaderLen += 3;
                        }
                    }
                    if (vsa.hasContinuationByte) {
                        vsa.continuation = RadiusFormat.getUnsignedByte(buffer);
                        ++vsaHeaderLen;
                    }
                    valueLength = vsaLength - vsaHeaderLen;
                }
            } else {
                attr = AttributeFactory.borrow(type);
                if (attr == null) {
                    attr = AttributeFactory.attr(type);
                }
            }
            if (valueLength > 0) {
                attr.setValue(buffer.array(), buffer.position(), valueLength);
                buffer.position(buffer.position() + valueLength);
            } else {
                attr.setValue(null, 0, 0);
            }
            if (op > -1) {
                attr.setAttributeOp(op);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(long type, byte[] value) {
        return AttributeFactory.newAttribute(type >> 16, type & 0xFFFFL, value, -1);
    }

    public static AttributeList newAttributeList(long type, byte[] value) {
        AttributeList list = new AttributeList();
        AttributeFactory.addToAttributeList(list, type, value);
        return list;
    }

    public static int addToAttributeList(AttributeList list, long type, byte[] value) {
        int left = value == null ? 0 : value.length;
        int offset = 0;
        int cnt = 0;
        long vendor = type >> 16;
        int maxlen = vendor > 0L ? 247 : 253;
        type &= 0xFFL;
        while (left > 0) {
            int len = maxlen;
            if (left < maxlen) {
                len = left;
            }
            byte[] b = new byte[len];
            System.arraycopy(value, offset, b, 0, len);
            list.add(AttributeFactory.newAttribute(vendor, type, b, 8), false);
            offset += len;
            left -= len;
            ++cnt;
        }
        return cnt;
    }

    public static byte[] assembleAttributeList(AttributeList list, long type) {
        Object[] aList = list.getArray(type);
        if (aList != null) {
            RadiusAttribute a;
            int length = 0;
            for (int i = 0; i < aList.length; ++i) {
                a = (RadiusAttribute)aList[i];
                byte[] b = a.getValue().getBytes();
                if (b == null) continue;
                length += b.length;
            }
            byte[] byteBuffer = new byte[length];
            int offset = 0;
            for (int i = 0; i < aList.length; ++i) {
                a = (RadiusAttribute)aList[i];
                byte[] b = a.getValue().getBytes();
                System.arraycopy(b, 0, byteBuffer, offset, b.length);
                offset += b.length;
            }
            return byteBuffer;
        }
        return null;
    }

    public static RadiusAttribute newAttribute(String aName) throws UnknownAttributeException {
        Class<?> c = attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(AttributeDescription desc) throws UnknownAttributeException {
        return AttributeFactory.newAttribute(desc.getName(), desc.getValue(), desc.getOp());
    }

    public static RadiusAttribute newAttribute(String aName, String aValue, String aOp) throws UnknownAttributeException {
        RadiusAttribute attr = AttributeFactory.newAttribute(aName);
        attr.setAttributeOp(aOp);
        attr.setValue(aValue);
        return attr;
    }

    public static long getTypeByName(String aName) throws UnknownAttributeException {
        Class<?> c = attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
            return attr.getFormattedType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static LinkedHashMap<Long, Class<?>> getAttributeMap() {
        return attributeMap;
    }

    public static LinkedHashMap<String, Class<?>> getAttributeNameMap() {
        return attributeNameMap;
    }

    public static LinkedHashMap<Long, Class<?>> getVendorMap() {
        return vendorMap;
    }

    public static LinkedHashMap<Long, VendorValue> getVendorValueMap() {
        return vendorValueMap;
    }

    public static void poolStatus() {
        if (attributeObjectPool == null) {
            return;
        }
        System.err.println("AttributePool: active=" + attributeObjectPool.getNumActive() + " idle=" + attributeObjectPool.getNumIdle());
    }

    public static String getPoolStatus() {
        if (attributeObjectPool == null) {
            return "";
        }
        return "active=" + attributeObjectPool.getNumActive() + ", idle=" + attributeObjectPool.getNumIdle();
    }

    public static void recycle(RadiusAttribute a) {
        if (attributeObjectPool == null || !a.recyclable) {
            return;
        }
        if (a.recycled) {
            System.err.println("PROBLEM: Recycling " + a.toString() + " " + a.getFormattedType());
        }
        a.setOverflow(false);
        try {
            if (a instanceof VSAWithSubAttributes) {
                VSAWithSubAttributes aa = (VSAWithSubAttributes)a;
                AttributeList list = aa.getSubAttributes();
                list.clear();
            }
            attributeObjectPool.returnObject((Object)new Long(a.getFormattedType()), (Object)a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void recycle(AttributeList list) {
        for (RadiusAttribute a : list.getAttributeList()) {
            AttributeFactory.recycle(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VendorValue {
        private Class<?> c;
        private Map<Long, Class<?>> typeMap;
        private Map<String, Class<?>> nameMap;

        public VendorValue(Class<?> c, LinkedHashMap<Long, Class<?>> t, Map<String, Class<?>> n) {
            this.c = c;
            this.typeMap = t;
            this.nameMap = n;
        }

        public Map<String, Class<?>> getAttributeNameMap() {
            return this.nameMap;
        }

        public Map<Long, Class<?>> getAttributeMap() {
            return this.typeMap;
        }

        public Class<?> getDictClass() {
            return this.c;
        }
    }
}

