/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.List;
import javax.annotation.Resource;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Trapd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Trapd.class);
    public static final String LOG4J_CATEGORY = "trapd";
    private int m_status = 0;
    @Autowired
    private TrapReceiver m_trapReceiver;
    @Resource(name="snmpTrapAddress")
    private String m_snmpTrapAddress;
    @Resource(name="snmpTrapPort")
    private Integer m_snmpTrapPort;
    @Resource(name="snmpV3Users")
    private List<SnmpV3User> m_snmpV3Users;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    protected synchronized void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    protected synchronized void onStart() {
        this.m_status = 1;
        LOG.debug("start: Initializing the Trapd receiver");
        this.m_trapReceiver.start();
        this.m_status = 2;
        LOG.debug("start: Trapd is ready to receive traps");
    }

    protected void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LOG.debug("pause: Calling pause on trap receiver");
        this.m_trapReceiver.stop();
        this.m_status = 6;
        LOG.debug("pause: Trapd paused");
    }

    protected void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LOG.debug("resume: Calling resume on trap receiver");
        this.m_trapReceiver.start();
        this.m_status = 2;
        LOG.debug("resume: Trapd resumed");
    }

    protected synchronized void onStop() {
        this.m_status = 3;
        LOG.debug("stop: Closing communication paths");
        this.m_trapReceiver.stop();
        this.m_status = 4;
        LOG.debug("stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public long getV1TrapsReceived() {
        return TrapQueueProcessor.getV1TrapsReceived();
    }

    public long getV2cTrapsReceived() {
        return TrapQueueProcessor.getV2cTrapsReceived();
    }

    public long getV3TrapsReceived() {
        return TrapQueueProcessor.getV3TrapsReceived();
    }

    public long getTrapsDiscarded() {
        return TrapQueueProcessor.getTrapsDiscarded();
    }

    public long getTrapsErrored() {
        return TrapQueueProcessor.getTrapsErrored();
    }

    public TrapReceiver getTrapReceiver() {
        return this.m_trapReceiver;
    }

    public void setTrapReceiver(TrapReceiver trapReceiver) {
        this.m_trapReceiver = trapReceiver;
    }
}

