/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;

public class DiscoveryResults
implements Serializable {
    private static final long serialVersionUID = -3416001085353754747L;
    private final Map<InetAddress, Long> m_responses;
    private final String m_foreignSource;
    private final String m_location;

    public DiscoveryResults(Map<InetAddress, Long> responses, String foreignSource, String location) {
        this.m_responses = (Map)Preconditions.checkNotNull(responses, (Object)"ranges argument");
        this.m_foreignSource = (String)Preconditions.checkNotNull((Object)foreignSource, (Object)"foreignSource argument");
        this.m_location = (String)Preconditions.checkNotNull((Object)location, (Object)"location argument");
    }

    public Map<InetAddress, Long> getResponses() {
        return this.m_responses;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getLocation() {
        return this.m_location;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryResults other = (DiscoveryResults)obj;
        return Objects.equal(this.m_responses, other.m_responses) && Objects.equal((Object)this.m_foreignSource, (Object)other.m_foreignSource) && Objects.equal((Object)this.m_location, (Object)other.m_location);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_responses, this.m_foreignSource, this.m_location});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("responses", this.m_responses).add("foreignSource", (Object)this.m_foreignSource).add("location", (Object)this.m_location).toString();
    }
}

