/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.opennms.core.concurrent.ExecutorFactory;
import org.opennms.core.concurrent.ExecutorFactoryJavaImpl;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapNotificationHandler;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapQueueProcessorFactory;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapNotificationHandlerDefaultImpl
implements TrapNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrapNotificationHandlerDefaultImpl.class);
    public static final int TRAP_PROCESSOR_THREADS = Runtime.getRuntime().availableProcessors();
    private final ExecutorFactory m_executorFactory = new ExecutorFactoryJavaImpl();
    private final ExecutorService m_processorExecutor = this.m_executorFactory.newExecutor(TRAP_PROCESSOR_THREADS, Integer.MAX_VALUE, "OpenNMS.Trapd", "trapProcessors");
    private TrapQueueProcessorFactory m_processorFactory;
    private TrapdIpMgr m_trapdIpManager;

    @Override
    public void handleTrapNotification(TrapNotification message) {
        try {
            message.setTrapProcessor((TrapProcessor)new EventCreator(this.m_trapdIpManager));
            TrapQueueProcessor processor = this.m_processorFactory.getInstance(message);
            CompletableFuture.supplyAsync(processor::call, this.m_processorExecutor);
        }
        catch (Throwable e) {
            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public TrapQueueProcessorFactory getProcessorFactory() {
        return this.m_processorFactory;
    }

    public void setProcessorFactory(TrapQueueProcessorFactory m_processorFactory) {
        this.m_processorFactory = m_processorFactory;
    }

    public TrapdIpMgr getTrapdIpManager() {
        return this.m_trapdIpManager;
    }

    public void setTrapdIpManager(TrapdIpMgr trapdIpManager) {
        this.m_trapdIpManager = trapdIpManager;
    }
}

