/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.InetAddress;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.IcmpMessengerIOException;
import org.opennms.netmgt.icmp.jna.JnaPingReply;
import org.opennms.netmgt.icmp.jna.JnaPingRequest;
import org.opennms.netmgt.icmp.jna.PingReplyListener;
import org.opennms.netmgt.icmp.jna.V4Pinger;
import org.opennms.netmgt.icmp.jna.V6Pinger;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.ReplyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaIcmpMessenger
implements Messenger<JnaPingRequest, JnaPingReply>,
PingReplyListener {
    private static final Logger LOG = LoggerFactory.getLogger(JnaIcmpMessenger.class);
    private V4Pinger m_v4;
    private V6Pinger m_v6;
    private ReplyHandler<JnaPingReply> m_callback = null;

    public JnaIcmpMessenger(int pingerId) throws Exception {
        Throwable error = null;
        try {
            this.m_v4 = new V4Pinger(pingerId);
            this.m_v4.addPingReplyListener(this);
        }
        catch (Throwable t) {
            LOG.debug("Unable to initialize IPv4 Pinger.", t);
            error = t;
            this.m_v4 = null;
        }
        try {
            this.m_v6 = new V6Pinger(pingerId);
            this.m_v6.addPingReplyListener(this);
        }
        catch (Throwable t) {
            LOG.debug("Unable to initialize IPv6 Pinger.", t);
            if (error == null) {
                error = t;
            }
            this.m_v6 = null;
        }
        if (this.m_v4 == null && this.m_v6 == null) {
            IcmpMessengerIOException exception = new IcmpMessengerIOException("IPv4 and IPv6 are not available.", error);
            LOG.warn("Unable to initialize JNA ICMP messenger", (Throwable)exception);
            throw exception;
        }
    }

    public boolean isV4Available() {
        return this.m_v4 != null;
    }

    public boolean isV6Available() {
        return this.m_v6 != null;
    }

    public void sendRequest(JnaPingRequest request) {
        request.send(this.m_v4, this.m_v6);
    }

    public void start(ReplyHandler<JnaPingReply> callback) {
        this.m_callback = callback;
        if (this.m_v4 != null) {
            this.m_v4.start();
        }
        if (this.m_v6 != null) {
            this.m_v6.start();
        }
    }

    @Override
    public void onPingReply(InetAddress address, EchoPacket packet) {
        this.m_callback.handleReply((Object)new JnaPingReply(address, packet));
    }
}

