/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.snmp.BasicTrapProcessorFactory;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.TrapNotificationHandler;
import org.opennms.netmgt.trapd.TrapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapReceiverImpl
implements TrapReceiver,
TrapNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(TrapReceiverImpl.class);
    @Resource(name="snmpTrapAddress")
    private String m_snmpTrapAddress;
    @Resource(name="snmpTrapPort")
    private Integer m_snmpTrapPort;
    @Resource(name="snmpV3Users")
    private List<SnmpV3User> m_snmpV3Users;
    private boolean m_registeredForTraps;
    private List<TrapNotificationHandler> m_trapNotificationHandlers = Collections.emptyList();

    public TrapReceiverImpl(TrapdConfig config) throws SocketException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_snmpTrapPort = config.getSnmpTrapPort();
        this.m_snmpTrapAddress = config.getSnmpTrapAddress();
        this.m_snmpV3Users = config.getSnmpV3Users();
    }

    public TrapNotificationHandler getTrapNotificationHandlers() {
        return this.m_trapNotificationHandlers.get(0);
    }

    public void setTrapNotificationHandlers(TrapNotificationHandler handler) {
        this.m_trapNotificationHandlers = Collections.singletonList(handler);
    }

    public void trapReceived(TrapNotification trapNotification) {
        try {
            for (TrapNotificationHandler handler : this.m_trapNotificationHandlers) {
                handler.handleTrapNotification(trapNotification);
            }
        }
        catch (Throwable e) {
            LOG.error("Handler execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public void trapError(int error, String msg) {
        LOG.warn("Error Processing Received Trap: error = {} {}", (Object)error, (Object)(msg != null ? ", ref = " + msg : ""));
    }

    @Override
    public void start() {
        try {
            InetAddress address = this.getInetAddress();
            LOG.info("Listening on {}:{}", (Object)(address == null ? "[all interfaces]" : InetAddressUtils.str((InetAddress)address)), (Object)this.m_snmpTrapPort);
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)new BasicTrapProcessorFactory(), (InetAddress)address, (int)this.m_snmpTrapPort, this.m_snmpV3Users);
            this.m_registeredForTraps = true;
            LOG.debug("init: Creating the trap session");
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                Logging.withPrefix((String)"OpenNMS.Manager", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LOG.error("init: Failed to listen on SNMP trap port " + TrapReceiverImpl.this.m_snmpTrapPort + ", perhaps something else is already listening?", (Throwable)e);
                    }
                });
                LOG.error("init: Failed to listen on SNMP trap port " + this.m_snmpTrapPort + ", perhaps something else is already listening?", (Throwable)e);
                throw new UndeclaredThrowableException(e, "Failed to listen on SNMP trap port " + this.m_snmpTrapPort + ", perhaps something else is already listening?");
            }
            LOG.error("init: Failed to initialize SNMP trap socket on port " + this.m_snmpTrapPort, (Throwable)e);
            throw new UndeclaredThrowableException(e, "Failed to initialize SNMP trap socket on port " + this.m_snmpTrapPort);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.m_registeredForTraps) {
                LOG.debug("stop: Closing SNMP trap session.");
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (InetAddress)this.getInetAddress(), (int)this.m_snmpTrapPort);
                LOG.debug("stop: SNMP trap session closed.");
            } else {
                LOG.debug("stop: not attemping to closing SNMP trap session--it was never opened");
            }
        }
        catch (IOException e) {
            LOG.warn("stop: exception occurred closing session", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.debug("stop: The SNMP session was already closed", (Throwable)e);
        }
    }

    private InetAddress getInetAddress() {
        if (this.m_snmpTrapAddress.equals("*")) {
            return null;
        }
        return InetAddressUtils.addr((String)this.m_snmpTrapAddress);
    }
}

