/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.IOUtils;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.xml.JaxbUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public abstract class AbstractXmlRpcModule<S extends RpcRequest, T extends RpcResponse>
implements RpcModule<S, T> {
    private final Class<S> requestClazz;
    private final Class<T> responseClazz;
    private final ThreadLocal<XmlHandler<S>> requestXmlHandler = new ThreadLocal();
    private final ThreadLocal<XmlHandler<T>> responseXmlHandler = new ThreadLocal();

    public AbstractXmlRpcModule(Class<S> requestClazz, Class<T> responseClazz) {
        this.requestClazz = Objects.requireNonNull(requestClazz);
        this.responseClazz = Objects.requireNonNull(responseClazz);
    }

    public String marshalRequest(S request) {
        return this.getRequestXmlHandler().marshal(request);
    }

    public S unmarshalRequest(String requestXml) {
        return (S)((RpcRequest)this.getRequestXmlHandler().unmarshal(requestXml));
    }

    public String marshalResponse(T response) {
        return this.getResponseXmlHandler().marshal(response);
    }

    public T unmarshalResponse(String response) {
        return (T)((RpcResponse)this.getResponseXmlHandler().unmarshal(response));
    }

    private XmlHandler<S> getRequestXmlHandler() {
        XmlHandler<S> xmlHandler = this.requestXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.requestClazz);
            this.requestXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private XmlHandler<T> getResponseXmlHandler() {
        XmlHandler<T> xmlHandler = this.responseXmlHandler.get();
        if (xmlHandler == null) {
            xmlHandler = this.createXmlHandler(this.responseClazz);
            this.responseXmlHandler.set(xmlHandler);
        }
        return xmlHandler;
    }

    private <W> XmlHandler<W> createXmlHandler(Class<W> clazz) {
        try {
            return new XmlHandler<W>(clazz);
        }
        catch (Throwable t) {
            return new XmlHandler<W>(clazz);
        }
    }

    private static class XmlHandler<U> {
        private final Class<U> clazz;
        private final Marshaller marshaller;
        private final Unmarshaller unmarshaller;
        private final XMLFilter filter;

        public XmlHandler(Class<U> clazz) {
            JAXBContext context;
            this.clazz = clazz;
            try {
                context = JaxbUtils.getContextFor(clazz);
                this.filter = JaxbUtils.getXMLFilterForClass(clazz);
            }
            catch (JAXBException | SAXException e) {
                throw new RuntimeException(e);
            }
            this.marshaller = JaxbUtils.getMarshallerFor(clazz, (JAXBContext)context);
            this.unmarshaller = JaxbUtils.getUnmarshallerFor(clazz, (JAXBContext)context, (boolean)false);
        }

        public String marshal(U obj) {
            StringWriter jaxbWriter = new StringWriter();
            try {
                this.marshaller.marshal(obj, (Writer)jaxbWriter);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            return jaxbWriter.toString();
        }

        public U unmarshal(String xml) {
            StringReader sr = new StringReader(xml);
            InputSource is = new InputSource(sr);
            try {
                SAXSource source = new SAXSource(this.filter, is);
                JAXBElement element = this.unmarshaller.unmarshal((Source)source, this.clazz);
                Object object = element.getValue();
                return (U)object;
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((Reader)sr);
            }
        }
    }
}

