/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.util;

import org.opennms.core.utils.AlphaNumeric;
import org.opennms.netmgt.dao.api.IfLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIfLabel
implements IfLabel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIfLabel.class);

    @Override
    public final String getIfLabel(String name, String descr, String physAddr) {
        String label = null;
        if (name != null) {
            label = AlphaNumeric.parseAndReplace((String)name, (char)'_');
        } else if (descr != null) {
            label = AlphaNumeric.parseAndReplace((String)descr, (char)'_');
        } else {
            throw new IllegalArgumentException("Both name and descr are null, but at least one cannot be.");
        }
        if (physAddr != null) {
            if ((physAddr = AlphaNumeric.parseAndTrim((String)physAddr)).length() == 12) {
                label = label + "-" + physAddr;
            } else {
                LOG.debug("initialize: physical address len is NOT 12, physAddr={}", (Object)physAddr);
            }
        }
        return label;
    }
}

