/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.util.Properties;

public class JmsQueueNameFactory {
    private static final String NAME_FORMAT_WITH_LOCATION = "OpenNMS.%s.%s@%s";
    private static final String NAME_FORMAT_WITHOUT_LOCATION = "OpenNMS.%s.%s";
    private final String m_daemon;
    private final String m_endpoint;
    private final String m_location;

    public JmsQueueNameFactory(String daemon, String endpoint, String location) {
        this.m_daemon = daemon;
        this.m_endpoint = endpoint;
        this.m_location = location;
    }

    public JmsQueueNameFactory(String daemon, String endpoint) {
        this(daemon, endpoint, null);
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getDaemon() {
        return this.m_daemon;
    }

    public String getName() {
        if (this.m_location == null) {
            return this.getNameWithoutLocation();
        }
        return this.getNameWithLocation(this.m_location);
    }

    public String getNameWithoutLocation() {
        return String.format(NAME_FORMAT_WITHOUT_LOCATION, this.m_daemon, this.m_endpoint);
    }

    public String getNameWithLocation(String location) {
        return String.format(NAME_FORMAT_WITH_LOCATION, this.m_daemon, this.m_endpoint, location);
    }

    public Properties getProperties() {
        Properties retval = new Properties();
        retval.setProperty("queueName", this.getName());
        retval.setProperty("queueNameWithoutLocation", this.getNameWithoutLocation());
        return retval;
    }
}

