/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class HttpConsumer
extends DefaultConsumer
implements SuspendableService {
    private volatile boolean suspended;
    private boolean traceEnabled;

    public HttpConsumer(HttpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        if (endpoint.isTraceEnabled()) {
            this.setTraceEnabled(true);
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    public HttpBinding getBinding() {
        return this.getEndpoint().getBinding();
    }

    public String getPath() {
        return this.getEndpoint().getPath();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().connect(this);
        this.suspended = false;
    }

    protected void doStop() throws Exception {
        this.suspended = false;
        this.getEndpoint().disconnect(this);
        super.doStop();
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }
}

