/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.jna.sockaddr_in6;

public class Win32V6NativeSocket
extends NativeDatagramSocket {
    private final int m_sock;

    public Win32V6NativeSocket(int family, int type, int protocol) throws Exception {
        this.m_sock = this.socket(family, type, protocol);
    }

    public native int bind(int var1, sockaddr_in6 var2, int var3) throws LastErrorException;

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    public native int sendto(int var1, Buffer var2, int var3, int var4, sockaddr_in6 var5, int var6) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, sockaddr_in6 var5, int[] var6) throws LastErrorException;

    public native int closesocket(int var1) throws LastErrorException;

    @Override
    public int receive(NativeDatagramPacket p) throws UnknownHostException {
        sockaddr_in6 in_addr = new sockaddr_in6();
        int[] szRef = new int[]{in_addr.size()};
        ByteBuffer buf = p.getContent();
        int n = this.recvfrom(this.getSock(), buf, buf.capacity(), 0, in_addr, szRef);
        p.setLength(n);
        p.setAddress(in_addr.getAddress());
        p.setPort(in_addr.getPort());
        return n;
    }

    @Override
    public int send(NativeDatagramPacket p) {
        ByteBuffer buf = p.getContent();
        sockaddr_in6 destAddr = new sockaddr_in6(p.getAddress(), p.getPort());
        return this.sendto(this.getSock(), buf, buf.remaining(), 0, destAddr, destAddr.size());
    }

    @Override
    public int close() {
        return this.closesocket(this.getSock());
    }

    protected int getSock() {
        return this.m_sock;
    }

    static {
        Native.register((String)null);
    }
}

