/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SnmpConfigAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpConfigAccessService.class);
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private boolean m_dirty = false;
    private final ScheduledExecutorService m_executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SnmpConfig-Accessor-Thread");
        }
    });

    public SnmpConfigAccessService() {
        this.m_executor.schedule(new SaveCallable(), 1L, TimeUnit.SECONDS);
    }

    public void flushAll() {
        this.submitAndWait(new SaveCallable());
    }

    public SnmpAgentConfig getAgentConfig(final InetAddress addr) {
        this.flushAll();
        return this.submitAndWait(new Callable<SnmpAgentConfig>(){

            @Override
            public SnmpAgentConfig call() throws Exception {
                return SnmpPeerFactory.getInstance().getAgentConfig(addr);
            }
        });
    }

    public void define(final SnmpEventInfo eventInfo) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                SnmpPeerFactory.getInstance().define(eventInfo);
                SnmpConfigAccessService.this.m_dirty = true;
            }
        });
    }

    private <T> T submitAndWait(Callable<T> callable) {
        try {
            return this.m_executor.submit(callable).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Future<?> submitWriteOp(Runnable r) {
        return this.m_executor.submit(r);
    }

    private final class SaveCallable
    implements Callable<Void> {
        private SaveCallable() {
        }

        @Override
        public Void call() throws Exception {
            if (SnmpConfigAccessService.this.m_dirty) {
                LOG.debug("SnmpPeerFactory has been updated. Persisting to disk.");
                SnmpPeerFactory.getInstance().saveCurrent();
                SnmpConfigAccessService.this.m_dirty = false;
            }
            return null;
        }
    }
}

