/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLMappingLoader;

public class XMLClassDescriptorResolverImpl
implements XMLClassDescriptorResolver {
    private ClassCache _classCache = new ClassCache();
    private DescriptorCache _descriptorCache = new DescriptorCache();
    private Introspector _introspector = null;
    private ClassLoader _loader = null;
    private XMLMappingLoader _mappingLoader = null;
    private boolean _useIntrospection = true;

    public XMLClassDescriptorResolverImpl() {
        boolean loadPackageMappings = Boolean.valueOf(LocalConfiguration.getInstance().getProperties().getProperty("org.exolab.castor.xml.loadPackageMappings", "true"));
        this._descriptorCache.setLoadPackageMappings(loadPackageMappings);
    }

    public Introspector getIntrospector() {
        if (this._introspector == null) {
            this._introspector = new Introspector(this._loader);
        }
        return this._introspector;
    }

    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    public ClassDescriptor resolve(Class type) throws ResolverException {
        if (type == null) {
            return null;
        }
        String className = type.getName();
        if (this._descriptorCache.isMissingDescriptor(className)) {
            return null;
        }
        ClassLoader classLoader = this.getClassLoader(type.getClassLoader());
        XMLClassDescriptor descriptor = this.getDescriptor(className, classLoader);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = this.createDescriptor(type);
        if (descriptor != null) {
            return descriptor;
        }
        this._descriptorCache.addMissingDescriptor(className);
        return null;
    }

    public XMLClassDescriptor resolve(String className) throws ResolverException {
        return this.resolve(className, null);
    }

    public XMLClassDescriptor resolve(String className, ClassLoader loader) throws ResolverException {
        if (className == null || className.length() == 0) {
            String error = "Cannot resolve a null or zero-length class name.";
            throw new IllegalArgumentException(error);
        }
        if (this._descriptorCache.isMissingDescriptor(className)) {
            return null;
        }
        ClassLoader classLoader = this.getClassLoader(loader);
        XMLClassDescriptor descriptor = this.getDescriptor(className, classLoader);
        if (descriptor != null) {
            return descriptor;
        }
        Class _class = this._classCache.loadClass(className, classLoader);
        if (_class != null && (descriptor = this.createDescriptor(_class)) != null) {
            return descriptor;
        }
        this._descriptorCache.addMissingDescriptor(className);
        return null;
    }

    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            throw new IllegalArgumentException("Cannot resolve a null or zero-length xml name.");
        }
        List possibleMatches = this._descriptorCache.getDescriptorList(xmlName);
        if (possibleMatches.size() == 0) {
            return null;
        }
        if (possibleMatches.size() == 1) {
            return (XMLClassDescriptor)possibleMatches.get(0);
        }
        Iterator i = possibleMatches.iterator();
        while (i.hasNext()) {
            XMLClassDescriptor descriptor = (XMLClassDescriptor)i.next();
            if (!this.namespaceEquals(namespaceURI, descriptor.getNameSpaceURI())) continue;
            return descriptor;
        }
        return null;
    }

    public Iterator resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String error = "Cannot resolve a null or zero-length xml name.";
            throw new IllegalArgumentException(error);
        }
        return this._descriptorCache.getDescriptors(xmlName);
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setIntrospection(boolean enable) {
        this._useIntrospection = enable;
    }

    public void setLoadPackageMappings(boolean loadPackageMappings) {
        this._descriptorCache.setLoadPackageMappings(loadPackageMappings);
    }

    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = (XMLMappingLoader)mappingLoader;
        if (this._mappingLoader != null) {
            Iterator descriptors = this._mappingLoader.descriptorIterator();
            while (descriptors.hasNext()) {
                XMLClassDescriptor descriptor = (XMLClassDescriptor)descriptors.next();
                this._descriptorCache.addDescriptor(descriptor);
            }
        }
    }

    private XMLClassDescriptor createDescriptor(Class type) throws ResolverException {
        if (!this._useIntrospection) {
            return null;
        }
        try {
            XMLClassDescriptor descriptor = this.getIntrospector().generateClassDescriptor(type);
            if (descriptor != null) {
                this._descriptorCache.addDescriptor(type.getName(), descriptor);
                return descriptor;
            }
        }
        catch (MarshalException mx) {
            throw new ResolverException(mx);
        }
        return null;
    }

    private ClassLoader getClassLoader(ClassLoader loader) {
        if (loader != null) {
            return loader;
        }
        if (this._loader != null) {
            return this._loader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private XMLClassDescriptor loadDescriptorClass(String className, ClassLoader loader) {
        int offset;
        StringBuffer descriptorClassName = new StringBuffer(className);
        descriptorClassName.append("Descriptor");
        Class descriptorClass = this._classCache.loadClass(descriptorClassName.toString(), this.getClassLoader(loader));
        if (descriptorClass == null && (offset = descriptorClassName.lastIndexOf(".")) != -1) {
            descriptorClassName.insert(offset, ".");
            descriptorClassName.insert(offset + 1, "descriptors");
            descriptorClass = this._classCache.loadClass(descriptorClassName.toString(), this.getClassLoader(loader));
        }
        if (descriptorClass == null) {
            return null;
        }
        try {
            XMLClassDescriptor descriptor = (XMLClassDescriptor)descriptorClass.newInstance();
            this._descriptorCache.addDescriptor(className, descriptor);
            return descriptor;
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return null;
    }

    private boolean namespaceEquals(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || ns2.length() == 0;
        }
        if (ns2 == null) {
            return ns1.length() == 0;
        }
        return ns1.equals(ns2);
    }

    private XMLClassDescriptor getDescriptor(String className, ClassLoader loader) throws ResolverException {
        XMLClassDescriptor descriptor = this._descriptorCache.getDescriptor(className);
        if (descriptor != null) {
            return descriptor;
        }
        if (this._mappingLoader != null && (descriptor = (XMLClassDescriptor)this._mappingLoader.getDescriptor(className)) != null) {
            this._descriptorCache.addDescriptor(className, descriptor);
            return descriptor;
        }
        String packageName = this.getPackageName(className);
        this._descriptorCache.loadPackageMapping(packageName, loader);
        this._descriptorCache.loadCDRList(packageName, loader);
        descriptor = this._descriptorCache.getDescriptor(className);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = this.loadDescriptorClass(className, loader);
        if (descriptor != null) {
            return descriptor;
        }
        return null;
    }

    public void addClass(String className) {
        this.loadDescriptorClass(className, this._loader);
    }

    public void addClasses(String[] classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            this.addClass(classNames[i]);
        }
    }

    public void addPackage(String packageName) throws ResolverException {
        this._descriptorCache.loadCDRList(packageName, this._loader);
    }

    public void addPackages(String[] packageNames) throws ResolverException {
        for (int i = 0; i < packageNames.length; ++i) {
            this._descriptorCache.loadCDRList(packageNames[i], this._loader);
        }
    }

    public void loadClassDescriptors(String packageName) throws ResolverException {
        this._descriptorCache.loadCDRList(packageName, this._loader);
    }

    private String getPackageName(String className) {
        if (className == null) {
            return "";
        }
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(0, idx);
        }
        return "";
    }

    private static class DescriptorCache {
        private static final String PKG_CDR_LIST_FILE = ".castor.cdr";
        private static final String PKG_MAPPING_FILE = ".castor.xml";
        private static final String INTERNAL_CONTAINER_NAME = "-error-if-this-is-used-";
        private List _missingTypes;
        private Map _typeMap = new HashMap();
        private Map _xmlNameMap = new HashMap();
        private List _loadedPackageMappings;
        private List _loadedCDRLists;
        private boolean _loadPackageMappings = true;

        public DescriptorCache() {
            this._missingTypes = new ArrayList();
            this._loadedPackageMappings = new ArrayList();
            this._loadedCDRLists = new ArrayList();
        }

        private void addDescriptor(String className, XMLClassDescriptor descriptor) {
            this._typeMap.put(className, descriptor);
            String xmlName = descriptor.getXMLName();
            if (xmlName == null || xmlName.length() == 0) {
                return;
            }
            if (INTERNAL_CONTAINER_NAME.equals(xmlName)) {
                return;
            }
            List descriptorList = this.getDescriptorList(descriptor.getXMLName());
            if (!descriptorList.contains(descriptor)) {
                descriptorList.add(descriptor);
            }
        }

        public void addDescriptor(XMLClassDescriptor descriptor) {
            this.addDescriptor(descriptor.getJavaClass().getName(), descriptor);
        }

        public void addMissingDescriptor(String className) {
            this._missingTypes.add(className);
        }

        public XMLClassDescriptor getDescriptor(String className) {
            return (XMLClassDescriptor)this._typeMap.get(className);
        }

        public List getDescriptorList(String xmlName) {
            ArrayList list = (ArrayList)this._xmlNameMap.get(xmlName);
            if (list == null) {
                list = new ArrayList();
                this._xmlNameMap.put(xmlName, list);
            }
            return list;
        }

        public Iterator getDescriptors(String xmlName) {
            return this.getDescriptorList(xmlName).iterator();
        }

        public boolean isMissingDescriptor(String className) {
            return this._missingTypes.contains(className);
        }

        public synchronized void loadCDRList(String packageName, ClassLoader loader) throws ResolverException {
            if (this._loadedCDRLists.contains(packageName)) {
                return;
            }
            this._loadedCDRLists.add(packageName);
            URL url = loader.getResource(this.getQualifiedFileName(PKG_CDR_LIST_FILE, packageName));
            if (url == null) {
                return;
            }
            try {
                Properties cdrList = this.getProperties(url);
                Enumeration<Object> classes = cdrList.keys();
                while (classes.hasMoreElements()) {
                    String className = (String)classes.nextElement();
                    String descriptorClassName = (String)cdrList.get(className);
                    try {
                        Class<?> descriptorClass = loader.loadClass(descriptorClassName);
                        this.addDescriptor(className, (XMLClassDescriptor)descriptorClass.newInstance());
                    }
                    catch (Exception e) {}
                }
            }
            catch (IOException iox) {
                throw new ResolverException(iox);
            }
        }

        public synchronized void loadPackageMapping(String packageName, ClassLoader loader) {
            if (!this._loadPackageMappings || this._loadedPackageMappings.contains(packageName)) {
                return;
            }
            this._loadedPackageMappings.add(packageName);
            try {
                Mapping mapping = this.loadMapping(packageName, loader);
                if (mapping != null) {
                    MappingUnmarshaller unmarshaller = new MappingUnmarshaller();
                    MappingLoader mappingLoader = unmarshaller.getMappingLoader(mapping, BindingType.XML);
                    Iterator descriptors = mappingLoader.descriptorIterator();
                    while (descriptors.hasNext()) {
                        XMLClassDescriptor descriptor = (XMLClassDescriptor)descriptors.next();
                        this.addDescriptor(descriptor);
                    }
                }
            }
            catch (MappingException mappingException) {
                // empty catch block
            }
        }

        public void setLoadPackageMappings(boolean loadPackageMappings) {
            this._loadPackageMappings = loadPackageMappings;
        }

        private Properties getProperties(URL url) throws IOException {
            Properties cdrList = new Properties();
            InputStream stream = url.openStream();
            cdrList.load(stream);
            stream.close();
            return cdrList;
        }

        private String getQualifiedFileName(String fileName, String packageName) {
            if (packageName == null || packageName.length() == 0) {
                return fileName;
            }
            StringBuffer result = new StringBuffer();
            result.append(packageName.replace('.', '/'));
            result.append('/');
            result.append(fileName);
            return result.toString();
        }

        private Mapping loadMapping(String packageName, ClassLoader loader) throws MappingException {
            URL url = loader.getResource(this.getQualifiedFileName(PKG_MAPPING_FILE, packageName));
            if (url == null) {
                return null;
            }
            try {
                Mapping mapping = new Mapping(loader);
                mapping.loadMapping(url);
                return mapping;
            }
            catch (IOException ioex) {
                throw new MappingException(ioex);
            }
        }
    }

    private static class ClassCache {
        private List _missingClasses = new ArrayList();

        private ClassCache() {
        }

        public Class loadClass(String className, ClassLoader loader) {
            if (this._missingClasses.contains(className)) {
                return null;
            }
            try {
                if (loader != null) {
                    return loader.loadClass(className);
                }
                return Class.forName(className);
            }
            catch (NoClassDefFoundError ncdfe) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this._missingClasses.add(className);
            return null;
        }
    }
}

