/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.discovery.DiscoveryPingResponseCallback;
import org.opennms.netmgt.discovery.UnmanagedInterfaceFilter;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.util.Assert;

@EventListener(name="OpenNMS.Discovery", logPrefix="discovery")
public class Discovery
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Discovery.class);
    private static final DiscoveryPingResponseCallback cb = new DiscoveryPingResponseCallback();
    private static final String LOG4J_CATEGORY = "discovery";
    private DiscoveryConfigFactory m_discoveryFactory;
    private EventForwarder m_eventForwarder;
    private UnmanagedInterfaceFilter m_interfaceFilter = null;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private TransactionOperations m_transactionOperations;
    @Autowired
    @Qualifier(value="discoveryCamelContext")
    private CamelContext m_camelContext;

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setDiscoveryFactory(DiscoveryConfigFactory discoveryFactory) {
        this.m_discoveryFactory = discoveryFactory;
    }

    public DiscoveryConfigFactory getDiscoveryFactory() {
        return this.m_discoveryFactory;
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setUnmanagedInterfaceFilter(UnmanagedInterfaceFilter filter) {
        this.m_interfaceFilter = filter;
    }

    public UnmanagedInterfaceFilter getUnmanagedInterfaceFilter() {
        return this.m_interfaceFilter;
    }

    public Discovery() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() throws IllegalStateException {
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        Assert.state((this.m_discoveryFactory != null ? 1 : 0) != 0, (String)"must set the Discovery Factory property");
        cb.setDiscoveryFactory(this.m_discoveryFactory);
        try {
            LOG.debug("Initializing configuration...");
            this.m_discoveryFactory.reload();
            LOG.debug("Configuration initialized.  Init the factory...");
            EventIpcManagerFactory.init();
            LOG.debug("Factory init'd.");
        }
        catch (Throwable e) {
            LOG.debug("onInit: initialization failed", e);
            throw new IllegalStateException("Could not initialize discovery configuration.", e);
        }
        this.m_camelContext.getShutdownStrategy().setTimeout(5L);
        this.m_camelContext.getShutdownStrategy().setTimeUnit(TimeUnit.SECONDS);
    }

    protected void onStart() {
        this.syncAlreadyDiscovered();
        try {
            this.m_camelContext.start();
        }
        catch (Exception e) {
            LOG.error("Discovery startup failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onStop() {
        try {
            this.m_camelContext.stop();
        }
        catch (Exception e) {
            LOG.error("Discovery shutdown failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onPause() {
        try {
            this.m_camelContext.stop();
        }
        catch (Exception e) {
            LOG.error("Discovery pause failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onResume() {
        try {
            this.m_camelContext.start();
        }
        catch (Exception e) {
            LOG.error("Discovery resume failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void syncAlreadyDiscovered() {
        this.m_transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                Set<UnmanagedInterfaceFilter.LocationIpAddressKey> newAlreadyDiscovered = Collections.synchronizedSet(new HashSet());
                CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
                builder.ne("type", (Object)String.valueOf(OnmsNode.NodeType.DELETED.value()));
                for (OnmsNode node : Discovery.this.m_nodeDao.findMatching(builder.toCriteria())) {
                    for (OnmsIpInterface iface : node.getIpInterfaces()) {
                        if ("D".equals(iface.getIsManaged())) continue;
                        newAlreadyDiscovered.add(new UnmanagedInterfaceFilter.LocationIpAddressKey(node.getLocation().getLocationName(), iface.getIpAddressAsString()));
                    }
                }
                Discovery.this.m_interfaceFilter.setManagedAddresses(newAlreadyDiscovered);
                LOG.info("syncAlreadyDiscovered initialized list of managed IP addresses with {} members", (Object)Discovery.this.m_interfaceFilter.size());
            }
        });
    }

    @EventHandler(uei="uei.opennms.org/internal/discoveryConfigChange")
    public void handleDiscoveryConfigurationChanged(Event event) {
        LOG.info("handleDiscoveryConfigurationChanged: handling message that a change to configuration happened...");
        this.reloadAndReStart();
    }

    private void reloadAndReStart() {
        EventBuilder ebldr = null;
        try {
            this.m_discoveryFactory.reload();
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            this.stop();
            this.start();
        }
        catch (MarshalException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (ValidationException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (IOException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.m_eventForwarder.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void reloadDaemonConfig(Event e) {
        LOG.info("reloadDaemonConfig: processing reload daemon event...");
        if (this.isReloadConfigEventTarget(e)) {
            this.reloadAndReStart();
        }
        LOG.info("reloadDaemonConfig: reload daemon event processed.");
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Discovery".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: discovery was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeleted(Event event) {
        Long nodeId = event.getNodeid();
        if (nodeId == null) {
            LOG.error("uei.opennms.org/nodes/interfaceDeleted: Event with no node ID: " + event.toString());
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
        if (node == null) {
            LOG.warn("uei.opennms.org/nodes/interfaceDeleted: Cannot find node in DB: " + nodeId);
            return;
        }
        String iface = event.getInterface();
        if (iface != null && !"".equals(iface.trim())) {
            this.m_interfaceFilter.removeManagedAddress(node.getLocation().getLocationName(), iface);
            LOG.debug("Removed {} from known interface list", (Object)iface);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discResume")
    public void handleDiscoveryResume(Event event) {
        try {
            this.resume();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discPause")
    public void handleDiscoveryPause(Event event) {
        try {
            this.pause();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedInterface")
    public void handleNodeGainedInterface(Event event) {
        Long nodeId = event.getNodeid();
        if (nodeId == null) {
            LOG.error("uei.opennms.org/nodes/nodeGainedInterface: Event with no node ID: " + event.toString());
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
        if (node == null) {
            LOG.warn("uei.opennms.org/nodes/nodeGainedInterface: Cannot find node in DB: " + nodeId);
            return;
        }
        String iface = event.getInterface();
        if (iface != null && !"".equals(iface.trim())) {
            this.m_interfaceFilter.addManagedAddress(node.getLocation().getLocationName(), iface);
        }
        LOG.debug("Added interface {} as discovered", (Object)iface);
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

