/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.syslogd.BroadcastEventProcessor;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogdIPMgrJDBCImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Syslogd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Syslogd.class);
    public static final String LOG4J_CATEGORY = "syslogd";
    @Autowired
    private SyslogReceiver m_udpEventReceiver;
    private BroadcastEventProcessor m_broadcastEventProcessor;

    public Syslogd() {
        super(LOG4J_CATEGORY);
    }

    public SyslogReceiver getSyslogReceiver() {
        return this.m_udpEventReceiver;
    }

    public void setSyslogReceiver(SyslogReceiver receiver) {
        this.m_udpEventReceiver = receiver;
    }

    protected void onInit() {
        try {
            SyslogdIPMgrJDBCImpl.getInstance().dataSourceSync();
        }
        catch (SQLException e) {
            LOG.error("Failed to load known IP address list", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void onStart() {
        LOG.debug("Starting SyslogHandler");
        Thread rThread = new Thread((Runnable)this.m_udpEventReceiver, this.m_udpEventReceiver.getName());
        try {
            rThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            throw e;
        }
        try {
            this.m_broadcastEventProcessor = new BroadcastEventProcessor();
        }
        catch (Throwable e) {
            LOG.error("Failed to setup event reader", e);
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void onStop() {
        if (this.m_broadcastEventProcessor != null) {
            LOG.debug("stop: Stopping the Syslogd event receiver");
            this.m_broadcastEventProcessor.close();
            LOG.debug("stop: Stopped the Syslogd event receiver");
        }
        if (this.m_udpEventReceiver != null) {
            LOG.debug("stop: Stopping the Syslogd UDP receiver");
            try {
                this.m_udpEventReceiver.stop();
            }
            catch (InterruptedException e) {
                LOG.info("stop: Exception when stopping the Syslog UDP receiver: " + e.getMessage());
            }
            catch (Throwable e) {
                LOG.error("stop: Failed to stop the Syslog UDP receiver", e);
                throw new UndeclaredThrowableException(e);
            }
            LOG.debug("stop: Stopped the Syslogd UDP receiver");
        }
    }
}

