/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.siteStatusViews;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.siteStatusViews.Category;
import org.xml.sax.ContentHandler;

public class RowDef
implements Serializable {
    private String _label;
    private String _reportCategory = "Network Interfaces";
    private List<Category> _categoryList;

    public RowDef() {
        this.setReportCategory("Network Interfaces");
        this._categoryList = new ArrayList<Category>();
    }

    public void addCategory(Category vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(vCategory);
    }

    public void addCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(index, vCategory);
    }

    public Enumeration<Category> enumerateCategory() {
        return Collections.enumeration(this._categoryList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RowDef) {
            RowDef temp = (RowDef)obj;
            if (this._label != null) {
                if (temp._label == null) {
                    return false;
                }
                if (!this._label.equals(temp._label)) {
                    return false;
                }
            } else if (temp._label != null) {
                return false;
            }
            if (this._reportCategory != null) {
                if (temp._reportCategory == null) {
                    return false;
                }
                if (!this._reportCategory.equals(temp._reportCategory)) {
                    return false;
                }
            } else if (temp._reportCategory != null) {
                return false;
            }
            if (this._categoryList != null) {
                if (temp._categoryList == null) {
                    return false;
                }
                if (!this._categoryList.equals(temp._categoryList)) {
                    return false;
                }
            } else if (temp._categoryList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Category getCategory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._categoryList.size()) {
            throw new IndexOutOfBoundsException("getCategory: Index value '" + index + "' not in range [0.." + (this._categoryList.size() - 1) + "]");
        }
        return this._categoryList.get(index);
    }

    public Category[] getCategory() {
        Category[] array = new Category[]{};
        return this._categoryList.toArray(array);
    }

    public List<Category> getCategoryCollection() {
        return this._categoryList;
    }

    public int getCategoryCount() {
        return this._categoryList.size();
    }

    public String getLabel() {
        return this._label;
    }

    public String getReportCategory() {
        return this._reportCategory;
    }

    public int hashCode() {
        int result = 17;
        if (this._label != null) {
            result = 37 * result + this._label.hashCode();
        }
        if (this._reportCategory != null) {
            result = 37 * result + this._reportCategory.hashCode();
        }
        if (this._categoryList != null) {
            result = 37 * result + this._categoryList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Category> iterateCategory() {
        return this._categoryList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCategory() {
        this._categoryList.clear();
    }

    public boolean removeCategory(Category vCategory) {
        boolean removed = this._categoryList.remove(vCategory);
        return removed;
    }

    public Category removeCategoryAt(int index) {
        Category obj = this._categoryList.remove(index);
        return obj;
    }

    public void setCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._categoryList.size()) {
            throw new IndexOutOfBoundsException("setCategory: Index value '" + index + "' not in range [0.." + (this._categoryList.size() - 1) + "]");
        }
        this._categoryList.set(index, vCategory);
    }

    public void setCategory(Category[] vCategoryArray) {
        this._categoryList.clear();
        for (int i = 0; i < vCategoryArray.length; ++i) {
            this._categoryList.add(vCategoryArray[i]);
        }
    }

    public void setCategory(List<Category> vCategoryList) {
        this._categoryList.clear();
        this._categoryList.addAll(vCategoryList);
    }

    public void setCategoryCollection(List<Category> categoryList) {
        this._categoryList = categoryList;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setReportCategory(String reportCategory) {
        this._reportCategory = reportCategory;
    }

    public static RowDef unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RowDef)Unmarshaller.unmarshal(RowDef.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

