/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcServerProcessor;
import org.opennms.minion.core.api.MinionIdentity;

public class CamelRpcServerRouteManager {
    private final CamelContext context;
    private final MinionIdentity identity;
    private final Map<RpcModule<RpcRequest, RpcResponse>, String> routeIdsByModule = new ConcurrentHashMap<RpcModule<RpcRequest, RpcResponse>, String>();

    public CamelRpcServerRouteManager(CamelContext context, MinionIdentity identity) throws Exception {
        this.context = Objects.requireNonNull(context);
        this.identity = Objects.requireNonNull(identity);
        context.start();
    }

    public void bind(RpcModule module) throws Exception {
        if (module != null) {
            RpcModule rpcModule = module;
            DynamicRpcRouteBuilder routeBuilder = new DynamicRpcRouteBuilder(this.context, this.identity, rpcModule);
            this.context.addRoutes((RoutesBuilder)routeBuilder);
            this.routeIdsByModule.put((RpcModule<RpcRequest, RpcResponse>)rpcModule, routeBuilder.getRouteId());
        }
    }

    public void unbind(RpcModule module) throws Exception {
        String routeId;
        if (module != null && (routeId = this.routeIdsByModule.remove(module)) != null) {
            this.context.stopRoute(routeId);
            this.context.removeRoute(routeId);
        }
    }

    private static final class DynamicRpcRouteBuilder
    extends RouteBuilder {
        private final RpcModule<RpcRequest, RpcResponse> module;
        private final JmsQueueNameFactory queueNameFactory;

        private DynamicRpcRouteBuilder(CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
            super(context);
            this.module = module;
            this.queueNameFactory = new JmsQueueNameFactory("RPC", module.getId(), identity.getLocation());
        }

        public String getRouteId() {
            return "RPC.Server." + this.module.getId();
        }

        public void configure() throws Exception {
            ((RouteDefinition)((RouteDefinition)this.from(String.format("queuingservice:%s", this.queueNameFactory.getName())).setExchangePattern(ExchangePattern.InOut)).process((Processor)new CamelRpcServerProcessor(this.module))).routeId(this.getRouteId());
        }
    }
}

