/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import com.sun.jna.Platform;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.ip.ICMPEchoPacket;
import org.opennms.jicmp.ip.ICMPPacket;
import org.opennms.jicmp.ip.IPPacket;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.standalone.AbstractPinger;
import org.opennms.jicmp.standalone.PingReplyListener;
import org.opennms.jicmp.standalone.PingReplyMetric;
import org.opennms.jicmp.standalone.V4PingReply;
import org.opennms.jicmp.standalone.V4PingRequest;

public class V4Pinger
extends AbstractPinger<Inet4Address> {
    public V4Pinger() throws Exception {
        super(NativeDatagramSocket.create(2, V4Pinger.getSocketType(), 1));
        if (Platform.isWindows()) {
            ICMPEchoPacket packet = new ICMPEchoPacket(64);
            packet.setCode(0);
            packet.setType(ICMPPacket.Type.EchoRequest);
            packet.getContentBuffer().putLong(System.nanoTime());
            packet.getContentBuffer().putLong(System.nanoTime());
            this.getPingSocket().send(packet.toDatagramPacket(InetAddress.getLocalHost()));
        }
    }

    @Override
    public void run() {
        try {
            NativeDatagramPacket datagram = new NativeDatagramPacket(65535);
            while (!this.isFinished()) {
                this.getPingSocket().receive(datagram);
                long received = System.nanoTime();
                ICMPPacket icmpPacket = new ICMPPacket(this.getIPPayload(datagram));
                V4PingReply echoReply = icmpPacket.getType() == ICMPPacket.Type.EchoReply ? new V4PingReply(icmpPacket, received) : null;
                if (echoReply == null || !echoReply.isValid()) continue;
                System.out.printf("%d bytes from %s: tid=%d icmp_seq=%d time=%.3f ms%n", echoReply.getPacketLength(), datagram.getAddress().getHostAddress(), echoReply.getIdentifier(), echoReply.getSequenceNumber(), echoReply.elapsedTime(TimeUnit.MILLISECONDS));
                for (PingReplyListener listener : this.getListeners()) {
                    listener.onPingReply(datagram.getAddress(), echoReply);
                }
            }
        }
        catch (Throwable e) {
            this.m_throwable.set(e);
            e.printStackTrace();
        }
    }

    private ByteBuffer getIPPayload(NativeDatagramPacket datagram) {
        return new IPPacket(datagram.getContent()).getPayload();
    }

    @Override
    public PingReplyMetric ping(Inet4Address addr, int id, int sequenceNumber, int count, long interval) throws InterruptedException {
        PingReplyMetric metric = new PingReplyMetric(count, interval);
        this.addPingReplyListener(metric);
        NativeDatagramSocket socket = this.getPingSocket();
        for (int i = sequenceNumber; i < sequenceNumber + count; ++i) {
            V4PingRequest request = new V4PingRequest(id, i);
            request.send(socket, addr);
            Thread.sleep(interval);
        }
        return metric;
    }
}

