/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.KafkaConfig;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rUs!B\u0001\u0003\u0011\u00039\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148CA\u0005\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\")1#\u0003C\u0001)\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\b-%\u0011\r\u0011\"\u0001\u0018\u0003M)fn\u001b8po:dunZ#oI>3gm]3u+\u0005A\u0002CA\u0007\u001a\u0013\tQbB\u0001\u0003M_:<\u0007B\u0002\u000f\nA\u0003%\u0001$\u0001\u000bV].twn\u001e8M_\u001e,e\u000eZ(gMN,G\u000f\t\u0005\b=%\u0011\r\u0011\"\u0001 \u0003UA\u0015n\u001a5XCR,'/\\1sW\u001aKG.\u001a8b[\u0016,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019\u0019FO]5oO\"1\u0011&\u0003Q\u0001\n\u0001\na\u0003S5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f]\u0006lW\r\t\u0004\u0005\u0015\t\u00011f\u0005\u0003+\u00191\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u0005\u0003\u0015)H/\u001b7t\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011aB7fiJL7m]\u0005\u0003oQ\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!I$F!b\u0001\n\u0003Q\u0014AB2p]\u001aLw-F\u0001<!\tAA(\u0003\u0002>\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!y$F!A!\u0002\u0013Y\u0014aB2p]\u001aLw\r\t\u0005\t\u0003*\u0012\t\u0011)A\u0005\u0005\u0006!A/[7f!\ti3)\u0003\u0002E]\t!A+[7f\u0011!1%F!b\u0001\n\u00039\u0015\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003!\u0003\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0011i\\7\r\\5f]RT!!\u0014(\u0002\r%\u0003\u0014\n^3d\u0015\u0005y\u0015aA8sO&\u0011\u0011K\u0013\u0002\t5.\u001cE.[3oi\"A1K\u000bB\u0001B\u0003%\u0001*A\u0005{W\u000ec\u0017.\u001a8uA!AQK\u000bB\u0001B\u0003%a+A\u0005tG\",G-\u001e7feB\u0011QfV\u0005\u00031:\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0011iS#Q1A\u0005\u0002m\u000b!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005a\u0006CA/a\u001b\u0005q&BA0\u0005\u0003\rawnZ\u0005\u0003Cz\u0013!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011!\u0019'F!A!\u0002\u0013a\u0016a\u00037pO6\u000bg.Y4fe\u0002B\u0001\"\u001a\u0016\u0003\u0006\u0004%\tAZ\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o+\u00059\u0007C\u00015p\u001b\u0005I'B\u00016l\u0003\u0019\tGo\\7jG*\u0011A.\\\u0001\u000bG>t7-\u001e:sK:$(B\u00018%\u0003\u0011)H/\u001b7\n\u0005AL'!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005sU\t\u0005\t\u0015!\u0003h\u0003=I7o\u00155viRLgn\u001a#po:\u0004\u0003\"B\n+\t\u0003!HcB;wobL(p\u001f\t\u0003\u0011)BQ!O:A\u0002mBQ!Q:A\u0002\tCQAR:A\u0002!CQ!V:A\u0002YCQAW:A\u0002qCQ!Z:A\u0002\u001dDq! \u0016A\u0002\u0013\u0005a0A\bd_:$(o\u001c7mKJ,\u0005o\\2i+\u0005y\bcA\u0007\u0002\u0002%\u0019\u00111\u0001\b\u0003\u0007%sG\u000fC\u0005\u0002\b)\u0002\r\u0011\"\u0001\u0002\n\u0005\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR!\u00111BA\t!\ri\u0011QB\u0005\u0004\u0003\u001fq!\u0001B+oSRD\u0011\"a\u0005\u0002\u0006\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0018)\u0002\u000b\u0015B@\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003\u0006BA\u000b\u00037\u00012!DA\u000f\u0013\r\tyB\u0004\u0002\tm>d\u0017\r^5mK\"A\u00111\u0005\u0016C\u0002\u0013%a0A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003OQ\u0003\u0015!\u0003\u0000\u00039awnY1m\u0005J|7.\u001a:JI\u0002B\u0011\"a\u000b+\u0005\u0004%I!!\f\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t+\t\ty\u0003E\u0004.\u0003c\t)$a\u0012\n\u0007\u0005MbF\u0001\u0003Q_>d\u0007CB\u0007\u00028\u0005mr0C\u0002\u0002:9\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001f\u0003\u0007r1!DA \u0013\r\t\tED\u0001\u0007!J,G-\u001a4\n\u0007\u001d\n)EC\u0002\u0002B9\u0001B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0011aB2mkN$XM]\u0005\u0005\u0003#\nYEA\u0005QCJ$\u0018\u000e^5p]\"A\u0011Q\u000b\u0016!\u0002\u0013\ty#\u0001\bbY2\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0013\u0005e#\u00061A\u0005\n\u0005m\u0013\u0001\u00057fC\u0012,'\u000fU1si&$\u0018n\u001c8t+\t\ti\u0006\u0005\u0004\u0002`\u0005%\u0014qI\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\b\u0011\u0006\u001c\bnU3u\u0011%\tyG\u000ba\u0001\n\u0013\t\t(\u0001\u000bmK\u0006$WM\u001d)beRLG/[8og~#S-\u001d\u000b\u0005\u0003\u0017\t\u0019\b\u0003\u0006\u0002\u0014\u00055\u0014\u0011!a\u0001\u0003;B\u0001\"a\u001e+A\u0003&\u0011QL\u0001\u0012Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]N\u0004\u0003\"CA>U\t\u0007I\u0011BA?\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7\u000fT8dWV\u0011\u0011q\u0010\t\u0004C\u0005\u0005\u0015bAABE\t1qJ\u00196fGRD\u0001\"a\"+A\u0003%\u0011qP\u0001\u0016Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]NdunY6!\u0011%\tYI\u000bb\u0001\n\u0013\ti(\u0001\fsKBd\u0017nY1Ti\u0006$Xm\u00115b]\u001e,Gj\\2l\u0011!\tyI\u000bQ\u0001\n\u0005}\u0014a\u0006:fa2L7-Y*uCR,7\t[1oO\u0016dunY6!\u0011%\t\u0019J\u000bb\u0001\n\u0003\t)*A\u000bsKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005]\u0005c\u0001\u0005\u0002\u001a&\u0019\u00111\u0014\u0002\u0003+I+\u0007\u000f\\5dC\u001a+Go\u00195fe6\u000bg.Y4fe\"A\u0011q\u0014\u0016!\u0002\u0013\t9*\u0001\fsKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:!\u0011!\t\u0019K\u000bb\u0001\n\u00131\u0017\u0001\n5jO\"<\u0016\r^3s[\u0006\u00148n\u00115fG.\u0004v.\u001b8u)\"\u0014X-\u00193Ti\u0006\u0014H/\u001a3\t\u000f\u0005\u001d&\u0006)A\u0005O\u0006)\u0003.[4i/\u0006$XM]7be.\u001c\u0005.Z2l!>Lg\u000e\u001e+ie\u0016\fGm\u0015;beR,G\r\t\u0005\n\u0003WS#\u0019!C\u0001\u0003[\u000b\u0001\u0004[5hQ^\u000bG/\u001a:nCJ\\7\t[3dWB|\u0017N\u001c;t+\t\ty\u000b\u0005\u0005\u00022\u0006]\u00161HA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006\u0015\u0014!C5n[V$\u0018M\u00197f\u0013\u0011\tI,a-\u0003\u00075\u000b\u0007\u000fE\u0002\t\u0003{K1!a0\u0003\u0005AyeMZ:fi\u000eCWmY6q_&tG\u000f\u0003\u0005\u0002D*\u0002\u000b\u0011BAX\u0003eA\u0017n\u001a5XCR,'/\\1sW\u000eCWmY6q_&tGo\u001d\u0011\t\u0013\u0005\u001d'\u00061A\u0005\n\u0005%\u0017a\u00055x)\"\u0014X-\u00193J]&$\u0018.\u00197ju\u0016$WCAAf!\ri\u0011QZ\u0005\u0004\u0003\u001ft!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'T\u0003\u0019!C\u0005\u0003+\fq\u0003[<UQJ,\u0017\rZ%oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\t\u0005-\u0011q\u001b\u0005\u000b\u0003'\t\t.!AA\u0002\u0005-\u0007\u0002CAnU\u0001\u0006K!a3\u0002)!<H\u000b\u001b:fC\u0012Le.\u001b;jC2L'0\u001a3!\u0011%\tyN\u000bb\u0001\n\u0003\t\t/A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\"!a9\u0011\t\u0005\u0015\u0018q^\u0007\u0003\u0003OTA!!;\u0002l\u0006)An\\45U*\u0019\u0011Q\u001e(\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t0a:\u0003\r1{wmZ3s\u0011!\t)P\u000bQ\u0001\n\u0005\r\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002B\u0011\"!?+\u0005\u0004%\t!a?\u0002\u001b%\u001c(/\u0012=qC:$'+\u0019;f+\t\ti\u0010\u0005\u0003\u0002\u0000\n=QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\t\r|'/\u001a\u0006\u0004k\t\u001d!\u0002\u0002B\u0005\u0005\u0017\ta!_1n[\u0016\u0014(B\u0001B\u0007\u0003\r\u0019w.\\\u0005\u0005\u0005#\u0011\tAA\u0003NKR,'\u000f\u0003\u0005\u0003\u0016)\u0002\u000b\u0011BA\u007f\u00039I7O]#ya\u0006tGMU1uK\u0002B\u0011B!\u0007+\u0005\u0004%\t!a?\u0002\u001b%\u001c(o\u00155sS:\\'+\u0019;f\u0011!\u0011iB\u000bQ\u0001\n\u0005u\u0018AD5teNC'/\u001b8l%\u0006$X\r\t\u0005\b\u0005CQC\u0011\u0001B\u0012\u0003u)h\u000eZ3s%\u0016\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\\\"pk:$H#A@\t\u000f\t\u001d\"\u0006\"\u0001\u0003*\u0005\u00193\u000f^1si\"Kw\r[,bi\u0016\u0014X*\u0019:lg\u000eCWmY6Q_&tG\u000f\u00165sK\u0006$GCAA\u0006\u0011\u001d\u0011iC\u000bC\u0001\u0005_\t\u0001eZ3u%\u0016\u0004H.[2bi&|gNR1di>\u0014hi\u001c:QCJ$\u0018\u000e^5p]R)qP!\r\u00036!A!1\u0007B\u0016\u0001\u0004\tY$A\u0003u_BL7\rC\u0004\u00038\t-\u0002\u0019A@\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0005wQC\u0011\u0001B\u0015\u0003\u001d\u0019H/\u0019:ukBDqAa\u0010+\t\u0003\u0011\t%A\u0006ti>\u0004(+\u001a9mS\u000e\fG\u0003\u0003B\"\u0005\u0013\u0012YE!\u0014\u0011\u00075\u0011)%C\u0002\u0003H9\u0011Qa\u00155peRD\u0001Ba\r\u0003>\u0001\u0007\u00111\b\u0005\b\u0005o\u0011i\u00041\u0001\u0000\u0011!\u0011yE!\u0010A\u0002\u0005-\u0017a\u00043fY\u0016$X\rU1si&$\u0018n\u001c8\t\u000f\tM#\u0006\"\u0001\u0003V\u0005a1\u000f^8q%\u0016\u0004H.[2bgR!!q\u000bB5!\u001di\u0011q\u0007B-\u0005\u0007\u0002\u0002\"a\u0018\u0003\\\tu#1I\u0005\u0005\u0003s\u000b\t\u0007\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019\u0007B\u0001\u0007G>lWn\u001c8\n\t\t\u001d$\u0011\r\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002\u0003B6\u0005#\u0002\rA!\u001c\u0002%M$x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e\t\u0005\u0005_\u0012)(\u0004\u0002\u0003r)\u0019!1\u000f\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003x\tE$AE*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRDqAa\u001f+\t\u0003\u0011i(\u0001\u000bhKR|%o\u0011:fCR,\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003\u000f\u0012yH!!\u0003\u0004\"A!1\u0007B=\u0001\u0004\tY\u0004C\u0004\u00038\te\u0004\u0019A@\t\u000f\t\u0015%\u0011\u0010a\u0001\u007f\u0006\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\t%%\u0006\"\u0001\u0003\f\u0006aq-\u001a;QCJ$\u0018\u000e^5p]R1!Q\u0012BJ\u0005+\u0003R!\u0004BH\u0003\u000fJ1A!%\u000f\u0005\u0019y\u0005\u000f^5p]\"A!1\u0007BD\u0001\u0004\tY\u0004C\u0004\u00038\t\u001d\u0005\u0019A@\t\u000f\te%\u0006\"\u0001\u0003\u001c\u0006)r-\u001a;SKBd\u0017nY1Pe\u0016C8-\u001a9uS>tGC\u0002BO\u0005G\u0013)\u000b\u0005\u0003\u0002J\t}\u0015\u0002\u0002BQ\u0003\u0017\u0012qAU3qY&\u001c\u0017\r\u0003\u0005\u00034\t]\u0005\u0019AA\u001e\u0011\u001d\u00119Ka&A\u0002}\f\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\t-&\u0006\"\u0001\u0003.\u00069r-\u001a;MK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c\u000b\u0007\u0005;\u0013yK!-\t\u0011\tM\"\u0011\u0016a\u0001\u0003wAqAa\u000e\u0003*\u0002\u0007q\u0010C\u0004\u00036*\"\tAa.\u0002\u0015\u001d,GOU3qY&\u001c\u0017\r\u0006\u0005\u0003:\nm&Q\u0018B`!\u0015i!q\u0012BO\u0011!\u0011\u0019Da-A\u0002\u0005m\u0002b\u0002B\u001c\u0005g\u0003\ra \u0005\n\u0005\u0003\u0014\u0019\f%AA\u0002}\f\u0011B]3qY&\u001c\u0017-\u00133\t\u000f\t\u0015'\u0006\"\u0001\u0003H\u00061\"-Z2p[\u0016dU-\u00193fe>\u0013hi\u001c7m_^,'\u000f\u0006\u0003\u0003J\nE\u0007cB\u0007\u00028\t-'1\t\t\t\u0005\u001b\u0014y-!\u000e\u0003D5\u0011\u0011QM\u0005\u0005\u0003s\u000b)\u0007\u0003\u0005\u0003T\n\r\u0007\u0019\u0001Bk\u0003MaW-\u00193fe\u0006sG-S*S%\u0016\fX/Z:u!\u0011\u0011yGa6\n\t\te'\u0011\u000f\u0002\u0014\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u0005\b\u0005;TC\u0011\u0002Bp\u0003-i\u0017m[3MK\u0006$WM]:\u0015\u0019\u0005-!\u0011\u001dBs\u0005S\u0014)P!?\t\u000f\t\r(1\u001ca\u0001\u007f\u0006a1m\u001c8ue>dG.\u001a:JI\"9!q\u001dBn\u0001\u0004y\u0018!B3q_\u000eD\u0007\u0002\u0003Bv\u00057\u0004\rA!<\u0002\u001dA\f'\u000f^5uS>t7\u000b^1uKBA!Q\u001aBh\u0003\u000f\u0012y\u000f\u0005\u0003\u0003p\tE\u0018\u0002\u0002Bz\u0005c\u0012!\u0003U1si&$\u0018n\u001c8Ti\u0006$X-\u00138g_\"9!q\u001fBn\u0001\u0004y\u0018!D2peJ,G.\u0019;j_:LE\r\u0003\u0005\u0003|\nm\u0007\u0019\u0001B\u007f\u0003-\u0011Xm\u001d9p]N,W*\u00199\u0011\u0011\u0005}#1LA\u001b\u0005\u0007Bqa!\u0001+\t\u0013\u0019\u0019!A\u0007nC.,gi\u001c7m_^,'o\u001d\u000b\u000f\u0003\u0017\u0019)aa\u0002\u0004\n\r-11DB\u000f\u0011\u001d\u0011\u0019Oa@A\u0002}DqAa:\u0003\u0000\u0002\u0007q\u0010\u0003\u0005\u0003l\n}\b\u0019\u0001Bw\u0011!\u0019iAa@A\u0002\r=\u0011a\u00027fC\u0012,'o\u001d\t\u0007\u0005\u001b\u001c\tb!\u0006\n\t\rM\u0011Q\r\u0002\u0004'\u0016$\b\u0003BA%\u0007/IAa!\u0007\u0002L\t1!I]8lKJDqAa>\u0003\u0000\u0002\u0007q\u0010\u0003\u0005\u0003|\n}\b\u0019\u0001B\u007f\u0011\u001d\u0019\tC\u000bC\u0005\u0005S\ta\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000fC\u0004\u0004&)\"\taa\n\u0002-I,7m\u001c:e\r>dGn\\<feB{7/\u001b;j_:$\"\"a\u0003\u0004*\r-2QFB\u0018\u0011!\u0011\u0019da\tA\u0002\u0005m\u0002b\u0002B\u001c\u0007G\u0001\ra \u0005\b\u0005\u0003\u001c\u0019\u00031\u0001\u0000\u0011\u001d\u0019\tda\tA\u0002a\taa\u001c4gg\u0016$\bbBB\u001bU\u0011\u0005!\u0011F\u0001\u0019G\",7m\u001b9pS:$\b*[4i/\u0006$XM]7be.\u001c\bbBB\u001dU\u0011\u0005!\u0011F\u0001\tg\",H\u000fZ8x]\"I1Q\b\u0016\u0012\u0002\u0013\u00051qH\u0001\u0015O\u0016$(+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0005#fA@\u0004D-\u00121Q\t\t\u0005\u0007\u000f\u001a\t&\u0004\u0002\u0004J)!11JB'\u0003%)hn\u00195fG.,GMC\u0002\u0004P9\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\u0019f!\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final Scheduler scheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final Object replicaStateChangeLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final Logger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static String HighWatermarkFilename() {
        return ReplicaManager$.MODULE$.HighWatermarkFilename();
    }

    public static long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> x$1) {
        this.kafka$server$ReplicaManager$$leaderPartitions = x$1;
    }

    public Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    private Object replicaStateChangeLock() {
        return this.replicaStateChangeLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean x$1) {
        this.hwThreadInitialized = x$1;
    }

    public Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public int underReplicatedPartitionCount() {
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            Integer n = BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$leaderPartitions().count((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Partition x$1) {
                    return x$1.isUnderReplicated();
                }
            }));
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public void startHighWaterMarksCheckPointThread() {
        if (this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true)) {
            String x$9 = "highwatermark-checkpoint";
            Serializable x$10 = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointHighWatermarks();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            long x$11 = this.config().replicaHighWatermarkCheckpointIntervalMs();
            TimeUnit x$12 = TimeUnit.MILLISECONDS;
            long x$13 = this.scheduler.schedule$default$3();
            this.scheduler.schedule(x$9, (Function0<BoxedUnit>)x$10, x$13, x$11, x$12);
        }
    }

    public int getReplicationFactorForPartition(String topic, int partitionId) {
        Option<Partition> option;
        block4: {
            int n;
            block3: {
                block2: {
                    Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
                    option = partitionOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Partition partition = (Partition)some.x();
                    n = partition.replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                n = -1;
            }
            return n;
        }
        throw new MatchError(option);
    }

    public void startup() {
        String x$14 = "isr-expiration";
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        long x$16 = this.config().replicaLagTimeMaxMs();
        TimeUnit x$17 = TimeUnit.MILLISECONDS;
        long x$18 = this.scheduler.schedule$default$3();
        this.scheduler.schedule(x$14, (Function0<BoxedUnit>)x$15, x$18, x$16, x$17);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short stopReplica(String topic, int partitionId, boolean deletePartition) {
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d handling stop replica (delete=%s) for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), ((Object)BoxesRunTime.boxToBoolean((boolean)deletePartition)).toString(), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
        short errorCode = ErrorMapping$.MODULE$.NoError();
        Option<Partition> option = this.getPartition(topic, partitionId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            block11: {
                Some some = (Some)option;
                Partition partition = (Partition)some.x();
                Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)partition);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 10] lbl12 : MonitorExitStatement: MONITOREXIT : object
                    if (deletePartition) {
                        Partition removedPartition = this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
                        if (removedPartition == null) {
                            boxedUnit = BoxedUnit.UNIT;
                            break block11;
                        } else {
                            removedPartition.delete();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block11;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            None$ none$ = None$.MODULE$;
            Option<Partition> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d ignoring stop replica (delete=%s) for partition [%s,%d] as replica doesn't exist on broker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)deletePartition), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d finished handling stop replica (delete=%s) for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)deletePartition), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
        return errorCode;
    }

    public Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap = new HashMap();
            if (stopReplicaRequest.controllerEpoch() < this.controllerEpoch()) {
                this.stateChangeLogger().warn((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)stopReplicaRequest.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())).toString());
                tuple2 = new Tuple2((Object)responseMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                this.controllerEpoch_$eq(stopReplicaRequest.controllerEpoch());
                this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)stopReplicaRequest.partitions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(TopicAndPartition r) {
                        return new TopicAndPartition(r.topic(), r.partition());
                    }
                }, Set$.MODULE$.canBuildFrom())));
                stopReplicaRequest.partitions().foreach((Function1)new Serializable(this, stopReplicaRequest, responseMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;
                    private final HashMap responseMap$1;

                    public final Option<Object> apply(TopicAndPartition topicAndPartition) {
                        short errorCode = this.$outer.stopReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)errorCode));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest$1;
                        this.responseMap$1 = responseMap$1;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    public Partition getOrCreatePartition(String topic, int partitionId, int replicationFactor) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), new Partition(topic, partitionId, replicationFactor, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        }
        return partition;
    }

    public Option<Partition> getPartition(String topic, int partitionId) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String topic, int partition) {
        Option<Replica> replicaOpt = this.getReplica(topic, partition, this.getReplica$default$3());
        if (replicaOpt.isDefined()) {
            return (Replica)replicaOpt.get();
        }
        throw new ReplicaNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), topic, BoxesRunTime.boxToInteger((int)partition)})));
    }

    public Replica getLeaderReplicaIfLocal(String topic, int partitionId) {
        Option<Partition> partitionOpt;
        Option<Partition> option = partitionOpt = this.getPartition(topic, partitionId);
        None$ none$ = None$.MODULE$;
        Option<Partition> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new UnknownTopicOrPartitionException(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.x();
            Option<Replica> option3 = partition.leaderReplicaIfLocal();
            if (option3 instanceof Some) {
                Replica leaderReplica;
                Replica replica;
                Some some2 = (Some)option3;
                Replica replica2 = replica = (leaderReplica = (Replica)some2.x());
                return replica2;
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option4 = option3;
            if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option3);
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(String topic, int partitionId, int replicaId) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> partitionOpt;
                    option = partitionOpt = this.getPartition(topic, partitionId);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Partition partition = (Partition)some.x();
                option2 = partition.getReplica(replicaId);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndISRRequest) {
        leaderAndISRRequest.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$1) {
                Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    PartitionStateInfo stateInfo = (PartitionStateInfo)tuple2._2();
                    if (tuple22 != null) {
                        String topic = (String)tuple22._1();
                        int partition = tuple22._2$mcI$sp();
                        this.$outer.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request %s correlation id %d from controller %d epoch %d for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), stateInfo, BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), topic, BoxesRunTime.boxToInteger((int)partition)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
            }
        });
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap = new HashMap();
            if (leaderAndISRRequest.controllerEpoch() < this.controllerEpoch()) {
                leaderAndISRRequest.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    private final LeaderAndIsrRequest leaderAndISRRequest$1;

                    public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$2) {
                        Tuple2 tuple2;
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = x0$2;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                            this.$outer.stateChangeLogger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.$outer.controllerEpoch())})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                int controllerId = leaderAndISRRequest.controllerId();
                int correlationId = leaderAndISRRequest.correlationId();
                this.controllerEpoch_$eq(leaderAndISRRequest.controllerEpoch());
                HashMap partitionState = new HashMap();
                leaderAndISRRequest.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest, responseMap, controllerId, correlationId, partitionState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;
                    private final LeaderAndIsrRequest leaderAndISRRequest$1;
                    private final HashMap responseMap$2;
                    private final int controllerId$1;
                    private final int correlationId$1;
                    private final HashMap partitionState$1;

                    public final Object apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> x0$3) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple2._2();
                            if (tuple22 != null) {
                                Option option;
                                int partitionId;
                                String topic = (String)tuple22._1();
                                Partition partition = this.$outer.getOrCreatePartition(topic, partitionId = tuple22._2$mcI$sp(), partitionStateInfo.replicationFactor());
                                int partitionLeaderEpoch = partition.getLeaderEpoch();
                                if (partitionLeaderEpoch < partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()) {
                                    if (partitionStateInfo.allReplicas().contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()))) {
                                        option = this.partitionState$1.put((Object)partition, (Object)partitionStateInfo);
                                    } else {
                                        this.$outer.stateChangeLogger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request with correlation id %d from controller %d epoch %d as broker is not in assigned replica list %s for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.correlationId$1), BoxesRunTime.boxToInteger((int)this.controllerId$1), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), partitionStateInfo.allReplicas().mkString(","), topic, BoxesRunTime.boxToInteger((int)partition.partitionId())})));
                                        option = BoxedUnit.UNIT;
                                    }
                                } else {
                                    this.$outer.stateChangeLogger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received invalid LeaderAndIsr request with correlation id %d from controller %d epoch %d with an older leader epoch %d for partition [%s,%d], current leader epoch is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.correlationId$1), BoxesRunTime.boxToInteger((int)this.controllerId$1), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()), topic, BoxesRunTime.boxToInteger((int)partition.partitionId()), BoxesRunTime.boxToInteger((int)partitionLeaderEpoch)})));
                                    option = this.responseMap$2.put((Object)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleLeaderEpochCode()));
                                }
                                Option option2 = option;
                                return option2;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndISRRequest$1;
                        this.responseMap$2 = responseMap$2;
                        this.controllerId$1 = controllerId$1;
                        this.correlationId$1 = correlationId$1;
                        this.partitionState$1 = partitionState$1;
                    }
                });
                HashMap partitionsTobeLeader = (HashMap)partitionState.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaManager $outer;

                    public final boolean apply(Tuple2<Partition, PartitionStateInfo> x0$4) {
                        Tuple2<Partition, PartitionStateInfo> tuple2 = x0$4;
                        if (tuple2 != null) {
                            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple2._2();
                            boolean bl = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader() == this.$outer.config().brokerId();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                HashMap partitionsToBeFollower = (HashMap)partitionState.$minus$minus((GenTraversableOnce)partitionsTobeLeader.keys());
                if (!partitionsTobeLeader.isEmpty()) {
                    this.makeLeaders(controllerId, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsTobeLeader, leaderAndISRRequest.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap);
                }
                if (!partitionsToBeFollower.isEmpty()) {
                    this.makeFollowers(controllerId, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsToBeFollower, leaderAndISRRequest.leaders(), leaderAndISRRequest.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap);
                }
                if (!this.hwThreadInitialized()) {
                    this.startHighWaterMarksCheckPointThread();
                    this.hwThreadInitialized_$eq(true);
                }
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                tuple2 = new Tuple2((Object)responseMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    /*
     * Exception decompiling
     */
    private void makeLeaders(int controllerId, int epoch, Map<Partition, PartitionStateInfo> partitionState, int correlationId, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void makeFollowers(int controllerId, int epoch, Map<Partition, PartitionStateInfo> partitionState, Set<Broker> leaders, int correlationId, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        List curLeaderPartitions = null;
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            curLeaderPartitions = this.kafka$server$ReplicaManager$$leaderPartitions().toList();
        }
        curLeaderPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply(Partition partition) {
                partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void recordFollowerPosition(String topic, int partitionId, int replicaId, long offset) {
        Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
        if (partitionOpt.isDefined()) {
            ((Partition)partitionOpt.get()).updateLeaderHWAndMaybeExpandIsr(replicaId, offset);
        } else {
            this.warn((Function0<String>)new Serializable(this, topic, partitionId){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionId$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionId$1 = partitionId$1;
                }
            });
        }
    }

    public void checkpointHighWatermarks() {
        Iterable replicas = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final Option<Replica> apply(Partition x$5) {
                return x$5.getReplica(this.$outer.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Replica>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Replica replica = (Replica)some.x();
                    object = replica;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Replica> x1) {
                Option<Replica> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map replicasByDir = ((TraversableLike)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Replica x$6) {
                return x$6.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Replica x$7) {
                return ((Log)x$7.log().get()).dir().getParent();
            }
        });
        replicasByDir.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Iterable<Replica>> check$ifrefutable$1) {
                Tuple2<String, Iterable<Replica>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, Iterable<Replica>> x$8) {
                BoxedUnit boxedUnit;
                Tuple2<String, Iterable<Replica>> tuple2 = x$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                String dir = (String)tuple2._1();
                Iterable reps = (Iterable)tuple2._2();
                scala.collection.immutable.Map hwms = ((TraversableOnce)reps.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, Object> apply(Replica r) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(r)), (Object)BoxesRunTime.boxToLong((long)r.highWatermark()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                try {
                    ((OffsetCheckpoint)this.$outer.highWatermarkCheckpoints().apply((Object)dir)).write((Map<TopicAndPartition, Object>)hwms);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error writing to highwatermark file: ";
                        }
                    }, (Function0<Throwable>)new Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final IOException e$2;

                        public final IOException apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    Runtime.getRuntime().halt(1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutted down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig config, Time time, ZkClient zkClient, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown) {
        this.config = config;
        this.time = time;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.logManager = logManager;
        this.isShuttingDown = isShuttingDown;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = config.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaStateChangeLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(config, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)config.logDirs().map((Function1)new $anonfun$4(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                return this.$outer.underReplicatedPartitionCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("IsrShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

