/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;

final class SyslogdIPMgrJDBCImpl
implements SyslogdIPMgr {
    private static final String IP_LOAD_SQL = "SELECT ipAddr, nodeid FROM ipInterface";
    private static Map<String, Long> m_knownips = new ConcurrentHashMap<String, Long>();

    SyslogdIPMgrJDBCImpl() {
    }

    public static SyslogdIPMgr getInstance() {
        return new SyslogdIPMgrJDBCImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dataSourceSync() throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = DataSourceFactory.getInstance().getConnection();
            c.setReadOnly(true);
            s = c.createStatement();
            ResultSet rs = s.executeQuery(IP_LOAD_SQL);
            if (rs != null) {
                m_knownips.clear();
                while (rs.next()) {
                    m_knownips.put(rs.getString(1), rs.getLong(2));
                }
                rs.close();
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return SyslogdIPMgrJDBCImpl.getInstance().longValue(m_knownips.get(addr));
    }

    @Override
    public long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return SyslogdIPMgrJDBCImpl.getInstance().longValue(m_knownips.put(addr, nodeid));
    }

    @Override
    public long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return SyslogdIPMgrJDBCImpl.getInstance().longValue(m_knownips.remove(addr));
    }

    @Override
    public long longValue(Long result) {
        return result == null ? -1L : result;
    }
}

