/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.opennms.core.concurrent.ExecutorFactory;
import org.opennms.core.concurrent.ExecutorFactoryJavaImpl;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogProcessor;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverNioDisruptorImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioDisruptorImpl.class);
    private static final MetricRegistry METRICS = new MetricRegistry();
    private static final int SOCKET_TIMEOUT = 500;
    public static final int MAX_PACKET_SIZE = 4096;
    public static final int SOCKET_RECEIVER_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int EVENT_PARSER_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int EVENT_SENDER_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int SOCKET_BYTE_BUFFER_QUEUE_SIZE = 65536;
    public static final int EVENT_CONVERSION_TASK_QUEUE_SIZE = 65536;
    private ExecutorFactory m_executorFactory = new ExecutorFactoryJavaImpl();
    private volatile boolean m_stop;
    private DatagramChannel m_channel;
    private Thread m_context;
    private final SyslogdConfig m_config;
    private DistPollerDao m_distPollerDao = null;
    private ExecutorService m_socketReceivers;
    private ExecutorService m_syslogConnectionExecutor;
    private ExecutorService m_syslogProcessorExecutor;
    private final Disruptor<ByteBufferMessage> m_byteBuffers;
    private final RingBuffer<ByteBufferMessage> m_ringBuffer;

    public static DatagramChannel openChannel(SyslogdConfig config) throws SocketException, IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.socket().setReuseAddress(true);
        if (config.getListenAddress() != null && config.getListenAddress().length() != 0) {
            channel.socket().bind(new InetSocketAddress(InetAddressUtils.addr((String)config.getListenAddress()), config.getSyslogPort()));
        } else {
            channel.socket().bind(new InetSocketAddress(config.getSyslogPort()));
        }
        return channel;
    }

    public SyslogReceiverNioDisruptorImpl(SyslogdConfig config) throws SocketException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_stop = false;
        this.m_channel = null;
        this.m_config = config;
        this.m_byteBuffers = new Disruptor(() -> new ByteBufferMessage(), 65536, null);
        this.m_byteBuffers.start();
        this.m_ringBuffer = this.m_byteBuffers.getRingBuffer();
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.m_executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.m_executorFactory = executorFactory;
    }

    @Override
    public void stop() throws InterruptedException {
        this.m_stop = true;
        this.m_socketReceivers.shutdown();
        this.m_syslogConnectionExecutor.shutdown();
        this.m_syslogProcessorExecutor.shutdown();
        try {
            this.m_channel.close();
        }
        catch (IOException e) {
            LOG.warn("Exception while closing syslog channel: " + e.getMessage());
        }
        finally {
            this.m_channel = null;
        }
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)"syslogd");
        final Meter packetMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"packets"}));
        final Meter processorMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"processors"}));
        final Meter connectionMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"connections"}));
        final Histogram packetSizeHistogram = METRICS.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"packetSize"}));
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        this.m_socketReceivers = this.m_executorFactory.newExecutor(SOCKET_RECEIVER_THREADS, Integer.MAX_VALUE, "OpenNMS.Syslogd", "socketReceivers");
        this.m_syslogConnectionExecutor = this.m_executorFactory.newExecutor(EVENT_PARSER_THREADS, Integer.MAX_VALUE, "OpenNMS.Syslogd", "syslogConnections");
        this.m_syslogProcessorExecutor = this.m_executorFactory.newExecutor(EVENT_SENDER_THREADS, Integer.MAX_VALUE, "OpenNMS.Syslogd", "syslogProcessors");
        try {
            LOG.debug("Opening syslog channel...");
            this.m_channel = SyslogReceiverNioDisruptorImpl.openChannel(this.m_config);
        }
        catch (IOException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_channel.socket().setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Attempting to set receive buffer size to {}", (Object)Integer.MAX_VALUE);
            this.m_channel.socket().setReceiveBufferSize(Integer.MAX_VALUE);
            LOG.debug("Actual receive buffer size is {}", (Object)this.m_channel.socket().getReceiveBufferSize());
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)Integer.MAX_VALUE, (Object)e);
        }
        for (int i = 0; i < SOCKET_RECEIVER_THREADS; ++i) {
            this.m_socketReceivers.execute(new Runnable(){

                @Override
                public void run() {
                    boolean ioInterrupted = false;
                    while (!SyslogReceiverNioDisruptorImpl.this.m_stop) {
                        if (SyslogReceiverNioDisruptorImpl.this.m_context.isInterrupted()) {
                            LOG.debug("Thread context interrupted");
                            break;
                        }
                        try {
                            long sequence = SyslogReceiverNioDisruptorImpl.this.m_ringBuffer.next();
                            ByteBufferMessage message = (ByteBufferMessage)SyslogReceiverNioDisruptorImpl.this.m_ringBuffer.get(sequence);
                            InetSocketAddress source = (InetSocketAddress)SyslogReceiverNioDisruptorImpl.this.m_channel.receive(message.buffer);
                            packetMeter.mark();
                            message.buffer.flip();
                            packetSizeHistogram.update(message.buffer.remaining());
                            SyslogConnection conn = new SyslogConnection(source.getAddress(), source.getPort(), message.buffer, SyslogReceiverNioDisruptorImpl.this.m_config, SyslogReceiverNioDisruptorImpl.this.m_distPollerDao.whoami().getId());
                            CompletableFuture<SyslogProcessor> proc = CompletableFuture.supplyAsync(conn::call, SyslogReceiverNioDisruptorImpl.this.m_syslogConnectionExecutor);
                            proc.thenRun(() -> {
                                message.buffer.clear();
                                if (sequence % 50L == 0L) {
                                    LOG.debug("Released 50 more datagrams");
                                }
                                SyslogReceiverNioDisruptorImpl.this.m_ringBuffer.publish(sequence);
                                processorMeter.mark();
                            });
                            ((CompletableFuture)proc.thenAcceptAsync(c -> c.call(), (Executor)SyslogReceiverNioDisruptorImpl.this.m_syslogProcessorExecutor)).thenRun(() -> connectionMeter.mark());
                            ioInterrupted = false;
                        }
                        catch (SocketTimeoutException e) {
                            ioInterrupted = true;
                        }
                        catch (InterruptedIOException e) {
                            ioInterrupted = true;
                        }
                        catch (IOException e) {
                            LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                            break;
                        }
                    }
                    LOG.debug("Thread context exiting");
                }
            });
        }
    }

    private static class ByteBufferMessage {
        public final ByteBuffer buffer = ByteBuffer.allocate(4096);

        private ByteBufferMessage() {
        }
    }
}

