/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import org.opennms.netmgt.syslogd.SyslogSeverity;

public enum SyslogFacility {
    KERNEL(0, "kernel messages"),
    USER(1, "user-level messages"),
    MAIL(2, "mail system"),
    SYSTEM(3, "system daemons"),
    AUTH(4, "security/authorization messages"),
    SYSLOG(5, "messages generated internally by syslogd"),
    LPD(6, "line printer subsystem"),
    NEWS(7, "network news subsystem"),
    UUCP(8, "UUCP subsystem"),
    CLOCK(9, "clock daemon"),
    AUTHPRIV(10, "privileged security/authorization messages"),
    FTP(11, "FTP daemon"),
    NTP(12, "NTP subsystem"),
    AUDIT(13, "log audit"),
    ALERT(14, "log alert"),
    CRON(15, "cron daemon"),
    LOCAL0(16, "local use 0"),
    LOCAL1(17, "local use 1"),
    LOCAL2(18, "local use 2"),
    LOCAL3(19, "local use 3"),
    LOCAL4(20, "local use 4"),
    LOCAL5(21, "local use 5"),
    LOCAL6(22, "local use 6"),
    LOCAL7(23, "local use 7"),
    UNKNOWN(99, "unknown");

    public static final int MASK = 1016;
    private final int m_facility;
    private final String m_name;
    private final String m_description;

    private SyslogFacility(int fac, String description) {
        this.m_facility = fac;
        this.m_name = this.name().toLowerCase().intern();
        this.m_description = description.intern();
    }

    public int getFacilityNumber() {
        return this.m_facility;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getPriority(SyslogSeverity severity) {
        if (severity == null) {
            return this.m_facility & 0x3F8;
        }
        return this.m_facility & 0x3F8 | severity.getSeverityNumber();
    }

    public String toString() {
        return this.m_name;
    }

    public static SyslogFacility getFacility(int fac) {
        SyslogFacility[] facilities = SyslogFacility.values();
        if (facilities.length < fac) {
            return null;
        }
        return facilities[fac];
    }

    public static SyslogFacility getFacilityForCode(int code) {
        return SyslogFacility.getFacility((code & 0x3F8) >> 3);
    }
}

