/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TrapdIpManagerDaoImpl
implements TrapdIpMgr {
    private static final Logger LOG = LoggerFactory.getLogger(TrapdIpManagerDaoImpl.class);
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    protected Map<InetAddress, Integer> m_knownips = new ConcurrentHashMap<InetAddress, Integer>();

    @Override
    public synchronized void dataSourceSync() {
        this.m_knownips = this.m_ipInterfaceDao.getInterfacesForNodes();
    }

    @Override
    public synchronized int getNodeId(String addr) {
        if (addr == null) {
            return -1;
        }
        return this.intValue(this.m_knownips.get(InetAddressUtils.getInetAddress((String)addr)));
    }

    @Override
    public synchronized int setNodeId(String addr, int nodeid) {
        if (addr == null || nodeid == -1) {
            return -1;
        }
        if (this.m_knownips.containsKey(InetAddressUtils.getInetAddress((String)addr))) {
            OnmsIpInterface intf = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(nodeid), addr);
            if (intf != null && intf.isPrimary()) {
                LOG.info("setNodeId: adding SNMP primary IP address {} to known IP list", (Object)intf);
                return this.intValue(this.m_knownips.put(InetAddressUtils.getInetAddress((String)addr), nodeid));
            }
            return -1;
        }
        return this.intValue(this.m_knownips.put(InetAddressUtils.getInetAddress((String)addr), nodeid));
    }

    @Override
    public synchronized int removeNodeId(String addr) {
        if (addr == null) {
            return -1;
        }
        return this.intValue(this.m_knownips.remove(InetAddressUtils.getInetAddress((String)addr)));
    }

    @Override
    public int intValue(Integer result) {
        return result == null ? -1 : result;
    }
}

