/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.opennms.core.concurrent.ExecutorFactory;
import org.opennms.core.concurrent.ExecutorFactoryJavaImpl;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapNotificationHandler;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapQueueProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TrapNotificationHandlerDefaultImpl
implements TrapNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrapNotificationHandlerDefaultImpl.class);
    public static final int TRAP_PROCESSOR_THREADS = Runtime.getRuntime().availableProcessors();
    private final ExecutorFactory m_executorFactory = new ExecutorFactoryJavaImpl();
    private final ExecutorService m_processorExecutor = this.m_executorFactory.newExecutor(TRAP_PROCESSOR_THREADS, Integer.MAX_VALUE, "OpenNMS.Trapd", "trapProcessors");
    @Autowired
    private TrapQueueProcessorFactory m_processorFactory;
    @Autowired
    private EventCreator m_eventCreator;

    @Override
    public void handleTrapNotification(TrapNotification message) {
        try {
            message.setTrapProcessor((TrapProcessor)this.getEventCreator());
            TrapQueueProcessor processor = this.m_processorFactory.getInstance(message);
            CompletableFuture.supplyAsync(processor::call, this.m_processorExecutor);
        }
        catch (Throwable e) {
            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public TrapQueueProcessorFactory getProcessorFactory() {
        return this.m_processorFactory;
    }

    public void setProcessorFactory(TrapQueueProcessorFactory m_processorFactory) {
        this.m_processorFactory = m_processorFactory;
    }

    public EventCreator getEventCreator() {
        return this.m_eventCreator;
    }

    public void setEventCreator(EventCreator eventCreator) {
        this.m_eventCreator = eventCreator;
    }
}

