/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.RestRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelControllerImpl
implements CamelController {
    private static final Logger LOG = LoggerFactory.getLogger(CamelControllerImpl.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public List<CamelContext> getCamelContexts() {
        ArrayList<CamelContext> camelContexts = new ArrayList<CamelContext>();
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(CamelContext.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    CamelContext camelContext;
                    if (reference == null || (camelContext = (CamelContext)this.bundleContext.getService(reference)) == null) continue;
                    camelContexts.add(camelContext);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve the list of Camel contexts.", (Throwable)e);
        }
        Collections.sort(camelContexts, new Comparator<CamelContext>(){

            @Override
            public int compare(CamelContext o1, CamelContext o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return camelContexts;
    }

    @Override
    public CamelContext getCamelContext(String name) {
        for (CamelContext camelContext : this.getCamelContexts()) {
            if (!camelContext.getName().equals(name)) continue;
            return camelContext;
        }
        return null;
    }

    @Override
    public List<Route> getRoutes(String camelContextName) {
        return this.getRoutes(camelContextName, null);
    }

    @Override
    public List<Route> getRoutes(String camelContextName, String filter) {
        ArrayList<Route> routes = new ArrayList<Route>();
        if (camelContextName != null) {
            CamelContext context = this.getCamelContext(camelContextName);
            if (context != null) {
                for (Route route : context.getRoutes()) {
                    if (filter != null && !route.getId().matches(filter)) continue;
                    routes.add(route);
                }
            }
        } else {
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                for (Route route : camelContext.getRoutes()) {
                    if (filter != null && !route.getId().matches(filter)) continue;
                    routes.add(route);
                }
            }
        }
        Collections.sort(routes, new Comparator<Route>(){

            @Override
            public int compare(Route o1, Route o2) {
                String c2;
                String c1 = o1.getRouteContext().getCamelContext().getName();
                int answer = c1.compareTo(c2 = o2.getRouteContext().getCamelContext().getName());
                if (answer == 0) {
                    answer = o1.getId().compareTo(o2.getId());
                }
                return answer;
            }
        });
        return routes;
    }

    @Override
    public Route getRoute(String routeId, String camelContextName) {
        List<Route> routes = this.getRoutes(camelContextName);
        for (Route route : routes) {
            if (!route.getId().equals(routeId)) continue;
            return route;
        }
        return null;
    }

    @Override
    public RouteDefinition getRouteDefinition(String routeId, String camelContextName) {
        CamelContext context = this.getCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.getRouteDefinition(routeId);
    }

    @Override
    public List<RestDefinition> getRestDefinitions(String camelContextName) {
        CamelContext context = this.getCamelContext(camelContextName);
        if (context == null) {
            return null;
        }
        return context.getRestDefinitions();
    }

    @Override
    public List<Endpoint> getEndpoints(String camelContextName) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        if (camelContextName != null) {
            CamelContext context = this.getCamelContext(camelContextName);
            if (context != null) {
                ArrayList endpoints = new ArrayList(context.getEndpoints());
                Collections.sort(endpoints, new Comparator<Endpoint>(){

                    @Override
                    public int compare(Endpoint o1, Endpoint o2) {
                        return o1.getEndpointKey().compareTo(o2.getEndpointKey());
                    }
                });
                answer.addAll(endpoints);
            }
        } else {
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                ArrayList endpoints = new ArrayList(camelContext.getEndpoints());
                Collections.sort(endpoints, new Comparator<Endpoint>(){

                    @Override
                    public int compare(Endpoint o1, Endpoint o2) {
                        return o1.getEndpointKey().compareTo(o2.getEndpointKey());
                    }
                });
                answer.addAll(endpoints);
            }
        }
        return answer;
    }

    @Override
    public Map<String, List<RestRegistry.RestService>> getRestServices(String camelContextName) {
        LinkedHashMap<String, List<RestRegistry.RestService>> answer = new LinkedHashMap<String, List<RestRegistry.RestService>>();
        if (camelContextName != null) {
            CamelContext context = this.getCamelContext(camelContextName);
            if (context != null) {
                ArrayList services = new ArrayList(context.getRestRegistry().listAllRestServices());
                Collections.sort(services, new Comparator<RestRegistry.RestService>(){

                    @Override
                    public int compare(RestRegistry.RestService o1, RestRegistry.RestService o2) {
                        return o1.getUrl().compareTo(o2.getUrl());
                    }
                });
                answer.put(camelContextName, services);
            }
        } else {
            List<CamelContext> camelContexts = this.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                ArrayList services = new ArrayList(camelContext.getRestRegistry().listAllRestServices());
                Collections.sort(services, new Comparator<RestRegistry.RestService>(){

                    @Override
                    public int compare(RestRegistry.RestService o1, RestRegistry.RestService o2) {
                        return o1.getUrl().compareTo(o2.getUrl());
                    }
                });
                answer.put(camelContext.getName(), services);
            }
        }
        return answer;
    }
}

