/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;

@UriEndpoint(scheme="log")
public class LogEndpoint
extends ProcessorEndpoint {
    private volatile Processor logger;
    @UriParam
    private String level;
    @UriParam
    private String marker;
    @UriParam
    private Integer groupSize;
    @UriParam
    private Long groupInterval;
    @UriParam
    private Boolean groupActiveOnly;
    @UriParam
    private Long groupDelay;
    private ExchangeFormatter localFormatter;
    private Logger providedLogger;
    private String loggerName;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, Processor logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.logger == null) {
            CamelLogger camelLogger = null;
            LoggingLevel loggingLevel = LoggingLevel.INFO;
            if (this.level != null) {
                loggingLevel = LoggingLevel.valueOf(this.level);
            }
            camelLogger = this.providedLogger == null ? new CamelLogger(this.loggerName, loggingLevel, this.getMarker()) : new CamelLogger(this.providedLogger, loggingLevel, this.getMarker());
            if (this.getGroupSize() != null) {
                this.logger = new ThroughputLogger(camelLogger, this.getGroupSize());
            } else if (this.getGroupInterval() != null) {
                Boolean groupActiveOnly = this.getGroupActiveOnly() != null ? this.getGroupActiveOnly() : Boolean.TRUE;
                Long groupDelay = this.getGroupDelay();
                this.logger = new ThroughputLogger(camelLogger, this.getCamelContext(), this.getGroupInterval(), groupDelay, groupActiveOnly);
            } else {
                this.logger = new CamelLogProcessor(camelLogger, this.localFormatter);
            }
            this.setProcessor(this.logger);
        }
        ServiceHelper.startService(this.logger);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.logger);
    }

    public void setLogger(Processor logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    public Processor getLogger() {
        return this.logger;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new LogProducer(this, this.logger);
    }

    @Override
    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        this.groupInterval = groupInterval;
    }

    public Boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    public void setGroupActiveOnly(Boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public Long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(Long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public ExchangeFormatter getLocalFormatter() {
        return this.localFormatter;
    }

    public void setLocalFormatter(ExchangeFormatter localFormatter) {
        this.localFormatter = localFormatter;
    }

    public Logger getProvidedLogger() {
        return this.providedLogger;
    }

    public void setProvidedLogger(Logger providedLogger) {
        this.providedLogger = providedLogger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }
}

