/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractMergingJaxbConfigDao<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMergingJaxbConfigDao.class);
    private static final long DEFAULT_RELOAD_CHECK_INTERVAL = 5000L;
    private final Class<K> m_entityClass;
    private final String m_description;
    private final Path m_rootFile;
    private final Path m_includeFolder;
    private Long m_reloadCheckInterval = 5000L;
    private long m_lastUpdate = 0L;
    private long m_lastReloadCheck = 0L;
    private List<File> m_xmlFiles = null;
    private final Map<File, JaxbConfigDao> m_configDaosByPath = new HashMap<File, JaxbConfigDao>();
    private V m_object = null;

    public AbstractMergingJaxbConfigDao(Class<K> entityClass, String description, Path includeFolder) {
        this(entityClass, description, null, includeFolder);
    }

    public AbstractMergingJaxbConfigDao(Class<K> entityClass, String description, Path rootFile, Path includeFolder) {
        this.m_entityClass = Objects.requireNonNull(entityClass, "entityClass argument");
        this.m_description = Objects.requireNonNull(description, "description argument");
        this.m_rootFile = rootFile;
        this.m_includeFolder = Objects.requireNonNull(includeFolder, "includeFolder argument");
    }

    public abstract V translateConfig(K var1);

    public abstract V mergeConfigs(V var1, V var2);

    private synchronized void checkForUpdates() {
        if (this.m_reloadCheckInterval < 0L || System.currentTimeMillis() < this.m_lastReloadCheck + this.m_reloadCheckInterval) {
            return;
        }
        this.m_lastReloadCheck = System.currentTimeMillis();
        List<File> updatedListOfXmlFiles = this.getXmlFiles();
        if (this.m_xmlFiles == null || !this.m_xmlFiles.equals(updatedListOfXmlFiles)) {
            this.m_xmlFiles = updatedListOfXmlFiles;
            this.reconfigureDaos();
        }
        long mostRecentUpdate = 1L;
        ArrayList<Object> objects = new ArrayList<Object>();
        for (JaxbConfigDao dao : this.m_configDaosByPath.values()) {
            objects.add(dao.getContainer().getObject());
            mostRecentUpdate = Math.max(mostRecentUpdate, dao.getContainer().getLastUpdate());
        }
        if (mostRecentUpdate > this.m_lastUpdate) {
            Object mergedObject = null;
            for (Object e : objects) {
                mergedObject = this.mergeConfigs(e, mergedObject);
            }
            this.m_object = mergedObject;
            this.m_lastUpdate = System.currentTimeMillis();
        }
    }

    private void reconfigureDaos() {
        HashSet<File> xmlFilesWithUnusedDaos = new HashSet<File>();
        xmlFilesWithUnusedDaos.addAll(this.m_configDaosByPath.keySet());
        for (File xmlFile : this.m_xmlFiles) {
            JaxbConfigDao dao = this.m_configDaosByPath.get(xmlFile);
            if (dao == null) {
                FileSystemResource fs = new FileSystemResource(xmlFile);
                dao = new JaxbConfigDao();
                dao.setConfigResource((Resource)fs);
                dao.afterPropertiesSet();
                this.m_configDaosByPath.put(xmlFile, dao);
                continue;
            }
            xmlFilesWithUnusedDaos.remove(xmlFilesWithUnusedDaos);
        }
        for (File fileWithUnusedDao : xmlFilesWithUnusedDaos) {
            this.m_configDaosByPath.remove(fileWithUnusedDao);
        }
    }

    public V getObject() {
        this.checkForUpdates();
        return this.m_object;
    }

    private List<File> getXmlFiles() {
        Path opennmsHome = Paths.get(ConfigFileConstants.getHome(), new String[0]);
        LinkedList<File> xmlFiles = new LinkedList<File>();
        try (Stream<Path> stream = Files.walk(opennmsHome.resolve(this.m_includeFolder), 1, new FileVisitOption[0]);){
            stream.map(Path::toFile).filter(f -> f.isFile()).filter(f -> f.canRead()).filter(f -> f.getName().endsWith(".xml")).sorted().forEach(f -> xmlFiles.add((File)f));
        }
        catch (IOException e) {
            LOG.error("Failed to walk {} for {} ({})", new Object[]{this.m_includeFolder, this.m_entityClass, this.m_description});
        }
        LOG.debug("Found {} files in {}: {}", new Object[]{xmlFiles.size(), this.m_includeFolder, xmlFiles});
        if (this.m_rootFile != null) {
            xmlFiles.add(0, opennmsHome.resolve(this.m_rootFile).toFile());
        }
        return xmlFiles;
    }

    public Date getLastUpdate() {
        return new Date(this.m_lastUpdate);
    }

    public Long getReloadCheckInterval() {
        return this.m_reloadCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReloadCheckInterval(Long reloadCheckInterval) {
        this.m_reloadCheckInterval = reloadCheckInterval;
        Map<File, JaxbConfigDao> map = this.m_configDaosByPath;
        synchronized (map) {
            if (this.m_reloadCheckInterval != null && this.m_configDaosByPath != null) {
                this.m_configDaosByPath.values().stream().forEach(c -> c.setReloadCheckInterval(this.m_reloadCheckInterval));
            }
        }
    }

    private class JaxbConfigDao
    extends AbstractJaxbConfigDao<K, V> {
        public JaxbConfigDao() {
            super(AbstractMergingJaxbConfigDao.this.m_entityClass, AbstractMergingJaxbConfigDao.this.m_description);
        }

        @Override
        protected V translateConfig(K config) {
            return AbstractMergingJaxbConfigDao.this.translateConfig(config);
        }
    }
}

