/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.SharedSegment;

public class BroadcastDomain {
    volatile Set<Bridge> m_bridges = new HashSet<Bridge>();
    volatile List<SharedSegment> m_topology = new ArrayList<SharedSegment>();
    boolean m_lock = false;
    Object m_locker;

    public void clearTopology() {
        this.m_topology.clear();
    }

    public boolean isEmpty() {
        return this.m_bridges.isEmpty();
    }

    public Set<Integer> getBridgeNodesOnDomain() {
        HashSet<Integer> bridgeIds = new HashSet<Integer>();
        for (Bridge bridge : this.m_bridges) {
            bridgeIds.add(bridge.getId());
        }
        return bridgeIds;
    }

    public synchronized boolean getLock(Object locker) {
        if (this.m_lock) {
            return false;
        }
        if (locker == null) {
            return false;
        }
        this.m_lock = true;
        this.m_locker = locker;
        return true;
    }

    public synchronized boolean releaseLock(Object locker) {
        if (locker == null) {
            return false;
        }
        if (!this.m_lock) {
            return false;
        }
        if (!this.m_locker.equals(locker)) {
            return false;
        }
        this.m_locker = null;
        this.m_lock = false;
        return true;
    }

    public Set<Bridge> getBridges() {
        return this.m_bridges;
    }

    public List<SharedSegment> getTopology() {
        return this.m_topology;
    }

    public boolean hasRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return true;
        }
        return false;
    }

    public Integer getRootBridgeId() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge.getId();
        }
        return null;
    }

    public Bridge getRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge;
        }
        return null;
    }

    public void addBridge(Bridge bridge) {
        if (this.m_bridges.contains(bridge)) {
            return;
        }
        this.m_bridges.add(bridge);
    }

    public Bridge getBridge(int bridgeId) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getId() != bridgeId) continue;
            return bridge;
        }
        return null;
    }

    public Set<String> getMacsOnDomain() {
        HashSet<String> macs = new HashSet<String>();
        for (SharedSegment segment : this.m_topology) {
            macs.addAll(segment.getMacsOnSegment());
        }
        return macs;
    }

    public void add(SharedSegment segment) {
        this.m_topology.add(segment);
    }

    public void loadTopologyEntry(SharedSegment segment) {
        segment.setBroadcastDomain(this);
        this.m_topology.add(segment);
    }

    public boolean containsAtleastOne(Set<Integer> nodeids) {
        for (Bridge bridge : this.m_bridges) {
            for (Integer nodeid : nodeids) {
                if (bridge.getId().intValue() != nodeid.intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containBridgeId(int nodeid) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getId() != nodeid) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeBridge(int bridgeId) {
        Bridge bridge = null;
        for (Bridge curbridge : this.m_bridges) {
            if (curbridge.getId() != bridgeId) continue;
            bridge = curbridge;
            break;
        }
        if (bridge == null) {
            return;
        }
        if (this.m_bridges.size() == 1) {
            this.m_topology.clear();
            this.m_bridges.clear();
            return;
        }
        HashSet<Bridge> bridges = new HashSet<Bridge>();
        for (Bridge cur : this.m_bridges) {
            if (cur.getId() == bridgeId) continue;
            bridges.add(cur);
        }
        this.m_bridges = bridges;
    }

    public List<SharedSegment> getSharedSegmentOnTopologyForBridge(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgeIdsOnSegment().contains(bridgeId)) continue;
            segmentsOnBridge.add(segment);
        }
        return segmentsOnBridge;
    }

    public List<SharedSegment> removeSharedSegmentOnTopologyForBridge(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        ArrayList<SharedSegment> topology = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (segment.getBridgeIdsOnSegment().contains(bridgeId)) {
                segmentsOnBridge.add(segment);
                continue;
            }
            topology.add(segment);
        }
        this.m_topology = topology;
        return segmentsOnBridge;
    }

    public Set<Bridge> getBridgeOnSharedSegment(SharedSegment segment) {
        HashSet<Integer> nodeidsOnSegment = new HashSet<Integer>(segment.getBridgeIdsOnSegment());
        HashSet<Bridge> bridgesOn = new HashSet<Bridge>();
        for (Bridge bridge : this.m_bridges) {
            if (!nodeidsOnSegment.contains(bridge.getId())) continue;
            bridgesOn.add(bridge);
        }
        return bridgesOn;
    }

    public SharedSegment getSharedSegment(Integer bridgeId, Integer bridgePort) {
        if (bridgeId == null || bridgePort == null) {
            return null;
        }
        for (SharedSegment segment : this.m_topology) {
            if (!segment.containsPort(bridgeId, bridgePort)) continue;
            return segment;
        }
        return null;
    }

    public void hierarchySetUp(Bridge root) {
        if (root.isRootBridge()) {
            return;
        }
        root.setRootBridge(true);
        root.setRootPort(null);
        if (this.m_bridges.size() == 1) {
            return;
        }
        for (SharedSegment segment : this.getSharedSegmentOnTopologyForBridge(root.getId())) {
            segment.setDesignatedBridge(root.getId());
            this.tier(segment, root.getId());
        }
    }

    private void tier(SharedSegment segment, Integer rootid) {
        for (Integer bridgeid : segment.getBridgeIdsOnSegment()) {
            if (bridgeid.intValue() == rootid.intValue()) continue;
            Bridge bridge = this.getBridge(bridgeid);
            bridge.setRootPort(segment.getPortForBridge(bridgeid));
            bridge.setRootBridge(false);
            for (SharedSegment s2 : this.getSharedSegmentOnTopologyForBridge(bridgeid)) {
                if (s2.getDesignatedBridge() != null && s2.getDesignatedBridge().intValue() == rootid.intValue()) continue;
                s2.setDesignatedBridge(bridgeid);
                this.tier(s2, bridgeid);
            }
        }
    }
}

