/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportOutputWriter;

class TransportOutputAdaptor
implements TransportOutput {
    private TransportOutputWriter _transportOutputWriter;
    private final ByteBuffer _outputBuffer;
    private final ByteBuffer _head;
    private boolean _output_done = false;
    private boolean _head_closed = false;

    TransportOutputAdaptor(TransportOutputWriter transportOutputWriter, int maxFrameSize) {
        this._transportOutputWriter = transportOutputWriter;
        this._outputBuffer = maxFrameSize > 0 ? ByteBufferUtils.newWriteableBuffer(maxFrameSize) : ByteBufferUtils.newWriteableBuffer(4096);
        this._head = this._outputBuffer.asReadOnlyBuffer();
        this._head.limit(0);
    }

    @Override
    public int pending() {
        if (this._head_closed) {
            return -1;
        }
        this._output_done = this._transportOutputWriter.writeInto(this._outputBuffer);
        this._head.limit(this._outputBuffer.position());
        if (this._output_done && this._outputBuffer.position() == 0) {
            return -1;
        }
        return this._outputBuffer.position();
    }

    @Override
    public ByteBuffer head() {
        this.pending();
        return this._head;
    }

    @Override
    public void pop(int bytes) {
        this._outputBuffer.flip();
        this._outputBuffer.position(bytes);
        this._outputBuffer.compact();
        this._head.position(0);
        this._head.limit(this._outputBuffer.position());
    }

    @Override
    public void close_head() {
        this._head_closed = true;
        this._transportOutputWriter.closed();
    }
}

