/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.actors;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opennms.netmgt.discovery.messages.DiscoveryJob;
import org.opennms.netmgt.discovery.messages.DiscoveryResults;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Discoverer {
    private static final Logger LOG = LoggerFactory.getLogger(Discoverer.class);
    final Pinger m_pinger;

    public Discoverer(Pinger pinger) {
        this.m_pinger = (Pinger)Preconditions.checkNotNull((Object)pinger, (Object)"pinger argument");
    }

    public DiscoveryResults discover(DiscoveryJob job) {
        PingResponseTracker tracker = new PingResponseTracker();
        List addresses = StreamSupport.stream(job.getAddresses().spliterator(), false).filter(j -> j.getAddress() != null).collect(Collectors.toList());
        addresses.stream().map(a -> a.getAddress()).forEach(a -> tracker.expectCallbackFor((InetAddress)a));
        addresses.stream().forEach(a -> this.ping((IPPollAddress)a, tracker));
        if (!addresses.isEmpty()) {
            try {
                tracker.getLatch().await();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return new DiscoveryResults(tracker.getResponses(), job.getForeignSource(), job.getLocation());
    }

    private void ping(IPPollAddress pollAddress, PingResponseTracker tracker) {
        InetAddress address = pollAddress.getAddress();
        try {
            this.m_pinger.ping(address, pollAddress.getTimeout(), pollAddress.getRetries(), 1, (PingResponseCallback)tracker);
        }
        catch (Throwable e) {
            LOG.debug("Error pinging {}", (Object)address.getAddress(), (Object)e);
            tracker.handleError(address, null, e);
        }
    }

    private static class PingResponseTracker
    implements PingResponseCallback {
        private final Set<InetAddress> waitingFor = Sets.newConcurrentHashSet();
        private final Map<InetAddress, Long> m_responses = Maps.newConcurrentMap();
        private final CountDownLatch m_doneSignal = new CountDownLatch(1);

        private PingResponseTracker() {
        }

        public void expectCallbackFor(InetAddress address) {
            this.waitingFor.add(address);
        }

        public void handleResponse(InetAddress address, EchoPacket response) {
            if (response != null) {
                this.m_responses.put(address, response.getReceivedTimeNanos() - response.getSentTimeNanos());
            }
            this.afterHandled(address);
        }

        public void handleTimeout(InetAddress address, EchoPacket request) {
            LOG.debug("Request timed out: {}", (Object)address);
            this.afterHandled(address);
        }

        public void handleError(InetAddress address, EchoPacket request, Throwable t) {
            LOG.debug("Request timed out: {}", (Object)address);
            this.afterHandled(address);
        }

        private void afterHandled(InetAddress address) {
            this.waitingFor.remove(address);
            if (this.waitingFor.isEmpty()) {
                this.m_doneSignal.countDown();
            }
        }

        public CountDownLatch getLatch() {
            return this.m_doneSignal;
        }

        public Map<InetAddress, Long> getResponses() {
            return this.m_responses;
        }
    }
}

