/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.heartbeat.producer;

import java.util.Timer;
import java.util.TimerTask;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageProducer;
import org.opennms.core.ipc.sink.api.MessageProducerFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.minion.core.api.MinionIdentity;
import org.opennms.minion.heartbeat.common.HeartbeatModule;
import org.opennms.minion.heartbeat.common.MinionIdentityDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatProducer.class);
    private static final int PERIOD_MS = 30000;
    final Timer timer;

    public HeartbeatProducer(final MinionIdentity identity, MessageProducerFactory messageProducerFactory) {
        final MinionIdentityDTO identityDTO = new MinionIdentityDTO(identity);
        final MessageProducer delegate = messageProducerFactory.getProducer((SinkModule)new HeartbeatModule());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    LOG.info("Sending heartbeat to Minion with id: {} at location: {}", (Object)identity.getId(), (Object)identity.getLocation());
                    delegate.send((Message)identityDTO);
                }
                catch (Throwable t) {
                    LOG.error("An error occured while sending the heartbeat. Will try again in {} ms", (Object)30000, (Object)t);
                }
            }
        }, 0L, 30000L);
    }

    public void cancel() {
        this.timer.cancel();
    }
}

