/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.core.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.minion.core.api.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScvEnabledRestClientImpl
implements RestClient {
    public static final Logger LOG = LoggerFactory.getLogger(ScvEnabledRestClientImpl.class);
    private static final String VERSION_KEY = "version";
    private final URL url;
    private final SecureCredentialsVault scv;
    private final String scvAlias;

    public ScvEnabledRestClientImpl(String url, SecureCredentialsVault scv, String scvAlias) throws MalformedURLException {
        this.url = new URL(url);
        this.scv = Objects.requireNonNull(scv);
        this.scvAlias = Objects.requireNonNull(scvAlias);
    }

    private UsernamePasswordCredentials getCredentials() {
        Credentials credentials = this.scv.getCredentials(this.scvAlias);
        if (credentials == null) {
            LOG.warn("No credentials found in SCV for alias '{}'. Using default credentials.", (Object)this.scvAlias);
            return new UsernamePasswordCredentials("admin", "admin");
        }
        return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
    }

    private CloseableHttpResponse getResponse(HttpGet httpget) throws Exception {
        CloseableHttpResponse response = null;
        HttpHost target = new HttpHost(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (org.apache.http.auth.Credentials)this.getCredentials());
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        response = httpclient.execute(target, (HttpRequest)httpget, (HttpContext)localContext);
        return response;
    }

    public String getVersion() throws Exception {
        HttpGet httpget = new HttpGet(this.url.toExternalForm() + "/rest/info");
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.getResponse(httpget);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IllegalStateException(String.format("Oups. We were expecting a status code of 200, but got %d instead.", response.getStatusLine().getStatusCode()));
            }
            HttpEntity entity = response.getEntity();
            String json = EntityUtils.toString((HttpEntity)entity);
            Gson g = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            try {
                Map info = (Map)g.fromJson(json, type);
                String string = (String)info.get(VERSION_KEY);
                return string;
            }
            catch (IllegalStateException e) {
                try {
                    throw new IllegalStateException("Failed to parse JSON: " + json, e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public void ping() throws Exception {
        if (this.getVersion() == null) {
            throw new Exception("Server did not return a version.");
        }
    }

    public String getSnmpV3Users() throws Exception {
        String responseString = null;
        CloseableHttpResponse response = null;
        HttpGet httpget = new HttpGet(this.url.toExternalForm() + "/rest/config/trapd");
        response = this.getResponse(httpget);
        HttpEntity entity = response.getEntity();
        responseString = EntityUtils.toString((HttpEntity)entity);
        response.close();
        return responseString;
    }
}

