/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.core.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.minion.core.api.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScvEnabledRestClientImpl
implements RestClient {
    public static final Logger LOG = LoggerFactory.getLogger(ScvEnabledRestClientImpl.class);
    private final URL url;
    private final String username;
    private final String password;

    public ScvEnabledRestClientImpl(String url, SecureCredentialsVault scv, String scvAlias) throws MalformedURLException {
        this.url = new URL(url);
        Credentials amqCredentials = scv.getCredentials(scvAlias);
        if (amqCredentials == null) {
            LOG.warn("No credentials found in SCV for alias '{}'. Using default credentials.", (Object)scvAlias);
            this.username = "admin";
            this.password = "admin";
        } else {
            this.username = amqCredentials.getUsername();
            this.password = amqCredentials.getPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws Exception {
        HttpHost target = new HttpHost(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.username, this.password));
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();){
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
            HttpGet httpget = new HttpGet(this.url.toExternalForm() + "/rest/info");
            CloseableHttpResponse response = httpclient.execute(target, (HttpRequest)httpget, (HttpContext)localContext);
            response.close();
        }
    }
}

